/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.json.simple.parser.JSONParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.pentaho.js.require.RebuildCacheCallable;
import org.pentaho.js.require.RequireJsBundleListener;
import org.pentaho.js.require.RequireJsConfiguration;
import org.pentaho.js.require.RequireJsGenerator;

public class RequireJsConfigManager {
    public static final String PACKAGE_JSON_PATH = "META-INF/js/package.json";
    public static final String REQUIRE_JSON_PATH = "META-INF/js/require.json";
    public static final String EXTERNAL_RESOURCES_JSON_PATH = "META-INF/js/externalResources.json";
    public static final String STATIC_RESOURCES_JSON_PATH = "META-INF/js/staticResources.json";
    private final Map<Long, Map<String, Object>> configMap = new HashMap<Long, Map<String, Object>>();
    private final Map<Long, RequireJsConfiguration> requireConfigMap = new HashMap<Long, RequireJsConfiguration>();
    private final JSONParser parser = new JSONParser();
    private BundleContext bundleContext;
    private static ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("RequireJSConfigManager pool");
            return thread;
        }
    });
    private volatile Future<String> cache;
    private volatile long lastModified;
    private String contextRoot = "/";
    private RequireJsBundleListener bundleListener;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean updateBundleContext(Bundle bundle) {
        Map<String, Object> requireJsonObject;
        switch (bundle.getState()) {
            case 1: 
            case 2: 
            case 4: 
            case 16: {
                return this.updateBundleContextStopped(bundle);
            }
            case 32: {
                break;
            }
            default: {
                return true;
            }
        }
        boolean shouldInvalidate = false;
        URL packageJsonUrl = bundle.getResource(PACKAGE_JSON_PATH);
        URL configFileUrl = bundle.getResource(REQUIRE_JSON_PATH);
        URL externalResourcesUrl = bundle.getResource(EXTERNAL_RESOURCES_JSON_PATH);
        URL staticResourcesUrl = bundle.getResource(STATIC_RESOURCES_JSON_PATH);
        if (configFileUrl != null && (requireJsonObject = this.loadJsonObject(configFileUrl)) != null) {
            this.putInConfigMap(bundle.getBundleId(), requireJsonObject);
            shouldInvalidate = true;
        }
        if (!shouldInvalidate && packageJsonUrl != null) {
            shouldInvalidate = this.parsePackageInformation(bundle, packageJsonUrl);
        }
        if (externalResourcesUrl != null) {
            ArrayList<String> requireJsList;
            Map<String, Object> externalResourceJsonObject = this.loadJsonObject(externalResourcesUrl);
            Map<String, Object> staticResourceJsonObject = this.loadJsonObject(staticResourcesUrl);
            if (externalResourceJsonObject != null && (requireJsList = (ArrayList<String>)externalResourceJsonObject.get("requirejs")) != null) {
                if (staticResourceJsonObject != null) {
                    ArrayList<String> translatedList = new ArrayList<String>(requireJsList.size());
                    for (String element : requireJsList) {
                        boolean found = false;
                        for (String key : staticResourceJsonObject.keySet()) {
                            String strKey = key.toString();
                            if (!element.startsWith(strKey)) continue;
                            String value = staticResourceJsonObject.get(key).toString();
                            translatedList.add(value + element.substring(strKey.length()));
                            found = true;
                            break;
                        }
                        if (found) continue;
                        translatedList.add(element);
                    }
                    requireJsList = translatedList;
                }
                this.putInRequireConfigMap(bundle.getBundleId(), new RequireJsConfiguration(bundle, (List<String>)requireJsList));
                shouldInvalidate = true;
            }
        }
        return shouldInvalidate;
    }

    private boolean parsePackageInformation(Bundle bundle, URL resourceUrl) {
        try {
            URLConnection urlConnection = resourceUrl.openConnection();
            RequireJsGenerator gen = RequireJsGenerator.parseJsonPackage(urlConnection.getInputStream());
            if (gen != null) {
                RequireJsGenerator.ArtifactInfo artifactInfo = new RequireJsGenerator.ArtifactInfo("osgi-bundles", bundle.getSymbolicName(), bundle.getVersion().toString());
                RequireJsGenerator.ModuleInfo moduleInfo = gen.getConvertedConfig(artifactInfo);
                Map<String, Object> requireJsonObject = moduleInfo.getRequireJs();
                this.putInConfigMap(bundle.getBundleId(), requireJsonObject);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void putInConfigMap(long bundleId, Map<String, Object> config) {
        this.configMap.put(bundleId, config);
    }

    private void putInRequireConfigMap(long bundleId, RequireJsConfiguration config) {
        this.requireConfigMap.put(bundleId, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadJsonObject(URL url) {
        if (url == null) {
            return null;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            URLConnection urlConnection = url.openConnection();
            inputStream = urlConnection.getInputStream();
            inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            Map map = (Map)this.parser.parse((Reader)bufferedReader);
            return map;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public boolean updateBundleContextStopped(Bundle bundle) {
        Map<String, Object> bundleConfig = this.configMap.remove(bundle.getBundleId());
        RequireJsConfiguration requireJsConfiguration = this.requireConfigMap.remove(bundle.getBundleId());
        return bundleConfig != null || requireJsConfiguration != null;
    }

    public void invalidateCache(boolean shouldInvalidate) {
        if (shouldInvalidate) {
            this.lastModified = System.currentTimeMillis();
            if (this.cache != null) {
                this.cache.cancel(true);
            }
            this.cache = executorService.schedule(new RebuildCacheCallable(new HashMap<Long, Map<String, Object>>(this.configMap), new ArrayList<RequireJsConfiguration>(this.requireConfigMap.values())), 250L, TimeUnit.MILLISECONDS);
        }
    }

    public String getRequireJsConfig() {
        Future<String> cache = null;
        String result = null;
        int tries = 3;
        ExecutionException lastException = null;
        while (tries-- > 0 && (result == null || cache != this.cache)) {
            cache = this.cache;
            try {
                result = cache.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                lastException = e;
                this.invalidateCache(true);
            }
        }
        if (result == null) {
            result = "{}; // Error computing RequireJS Config: ";
            result = lastException != null ? result + lastException.getCause().getMessage() : result + "unknown error";
        }
        return result;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(Bundle bundle) {
        boolean shouldRefresh = true;
        try {
            shouldRefresh = this.updateBundleContext(bundle);
        }
        catch (Exception exception) {
        }
        finally {
            this.invalidateCache(shouldRefresh);
        }
    }

    public void init() throws Exception {
        this.bundleListener = new RequireJsBundleListener(this);
        this.bundleContext.addBundleListener((BundleListener)this.bundleListener);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.updateBundleContext(bundle);
        }
        this.updateBundleContext(this.bundleContext.getBundle());
        this.invalidateCache(true);
    }

    public void destroy() {
        if (this.bundleListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.bundleListener);
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        contextRoot = !contextRoot.startsWith("/") ? "/" + contextRoot : contextRoot;
        this.contextRoot = contextRoot = !contextRoot.endsWith("/") ? contextRoot + "/" : contextRoot;
    }
}

