/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromRepositoryProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandlerLib;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class RepositoryTransformationProducerWriteHandler
implements TransformationProducerWriteHandler {
    @Override
    public void writeKettleRepositoryProducer(WriteableDocumentBundle bundle, String dataSourceFileName, XmlWriter xmlWriter, String queryName, KettleTransformationProducer producer) throws IOException, BundleWriterException {
        if (!(producer instanceof KettleTransFromRepositoryProducer)) {
            throw new BundleWriterException("Invalid object type registered for handler of " + KettleTransFromRepositoryProducer.class.getSimpleName());
        }
        KettleTransFromRepositoryProducer repositoryProducer = (KettleTransFromRepositoryProducer)producer;
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", repositoryProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "directory", repositoryProducer.getDirectoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "transformation", repositoryProducer.getTransformationName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", repositoryProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", repositoryProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", PasswordEncryptionService.getInstance().encrypt(repositoryProducer.getPassword()));
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "stop-on-error", String.valueOf(repositoryProducer.isStopOnError()));
        String[] definedArgumentNames = repositoryProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = repositoryProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, false);
        TransformationProducerWriteHandlerLib.writeParameterAndArguments(xmlWriter, repositoryProducer);
        xmlWriter.writeCloseTag();
    }
}

