/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordActionSkipXCommand;
import org.apache.oozie.command.coord.CoordActionTimeOutXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.executor.jpa.CoordActionGetForInputCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordActionInputCheckXCommand
extends CoordinatorXCommand<Void> {
    private final String actionId;
    public static final String CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL = "oozie.service.coord.input.check.requeue.interval";
    private final int DEFAULT_COMMAND_REQUEUE_INTERVAL = 60000;
    private CoordinatorActionBean coordAction = null;
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;
    private String jobId = null;

    public CoordActionInputCheckXCommand(String actionId, String jobId) {
        super("coord_action_input", "coord_action_input", 1);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.jobId = jobId;
    }

    private Date computeNextNominalTime() throws ParseException {
        Date nextNominalTime;
        boolean isCronFrequency = false;
        int freq = -1;
        try {
            freq = Integer.parseInt(this.coordJob.getFrequency());
        }
        catch (NumberFormatException e) {
            isCronFrequency = true;
        }
        if (isCronFrequency) {
            nextNominalTime = CoordCommandUtils.getNextValidActionTimeForCronFrequency(this.coordAction.getNominalTime(), this.coordJob);
        } else {
            Calendar nextNominalTimeCal = Calendar.getInstance(DateUtils.getTimeZone(this.coordJob.getTimeZone()));
            nextNominalTimeCal.setTime(this.coordAction.getNominalTime());
            TimeUnit freqTU = TimeUnit.valueOf(this.coordJob.getTimeUnitStr());
            nextNominalTimeCal.add(freqTU.getCalendarUnit(), freq);
            nextNominalTime = nextNominalTimeCal.getTime();
        }
        if (nextNominalTime.after(this.coordJob.getEndTime())) {
            nextNominalTime = null;
        }
        return nextNominalTime;
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("[" + this.actionId + "]::ActionInputCheck:: Action is in WAITING state.");
        Date nominalTime = this.coordAction.getNominalTime();
        Date currentTime = new Date();
        if (nominalTime.compareTo(currentTime) > 0) {
            this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()), Math.max(nominalTime.getTime() - currentTime.getTime(), this.getCoordInputCheckRequeueInterval()));
            this.updateCoordAction(this.coordAction, false);
            this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: nominal Time is newer than current time, so requeue and wait. Current=" + DateUtils.formatDateOozieTZ(currentTime) + ", nominal=" + DateUtils.formatDateOozieTZ(nominalTime));
            return null;
        }
        StringBuilder actionXml = new StringBuilder(this.coordAction.getActionXml());
        boolean isChangeInDependency = false;
        try {
            String nonExistListStr;
            XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            Date now = new Date();
            if (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.LAST_ONLY)) {
                Date nextNominalTime = this.computeNextNominalTime();
                if (nextNominalTime != null) {
                    if (now.after(nextNominalTime)) {
                        this.LOG.info("LAST_ONLY execution: Preparing to skip action [{0}] because the current time [{1}] is later than the nominal time [{2}] of the next action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                        this.queue(new CoordActionSkipXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                        return null;
                    }
                    this.LOG.debug("LAST_ONLY execution: Not skipping action [{0}] because the current time [{1}] is earlier than the nominal time [{2}] of the next action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                }
            } else if (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.NONE)) {
                Calendar cal = Calendar.getInstance(DateUtils.getTimeZone(this.coordJob.getTimeZone()));
                cal.setTime(nominalTime);
                cal.add(12, Services.get().getConf().getInt("oozie.coord.execution.none.tolerance", 1));
                nominalTime = cal.getTime();
                if (now.after(nominalTime)) {
                    this.LOG.info("NONE execution: Preparing to skip action [{0}] because the current time [{1}] is later than the nominal time [{2}] of the current action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nominalTime));
                    this.queue(new CoordActionSkipXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                    return null;
                }
                this.LOG.debug("NONE execution: Not skipping action [{0}] because the current time [{1}] is earlier than the nominal time [{2}] of the current action]", this.coordAction.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(this.coordAction.getNominalTime()));
            }
            StringBuilder existList = new StringBuilder();
            StringBuilder nonExistList = new StringBuilder();
            StringBuilder nonResolvedList = new StringBuilder();
            String firstMissingDependency = "";
            String missingDeps = this.coordAction.getMissingDependencies();
            CoordCommandUtils.getResolvedList(missingDeps, nonExistList, nonResolvedList);
            if (nonExistList.length() > 0) {
                firstMissingDependency = nonExistList.toString().split("#")[0];
            }
            this.LOG.info("[" + this.actionId + "]::CoordActionInputCheck:: Missing deps:" + firstMissingDependency + " " + nonResolvedList.toString());
            boolean status = this.checkInput(actionXml, existList, nonExistList, actionConf);
            String pushDeps = this.coordAction.getPushMissingDependencies();
            if (status && nonResolvedList.length() > 0) {
                status = pushDeps == null || pushDeps.length() == 0 ? this.checkUnResolvedInput(actionXml, actionConf) : false;
            }
            this.coordAction.setLastModifiedTime(currentTime);
            this.coordAction.setActionXml(actionXml.toString());
            if (nonResolvedList.length() > 0 && !status) {
                nonExistList.append("!!").append((CharSequence)nonResolvedList);
            }
            if (!(nonExistListStr = nonExistList.toString()).equals(missingDeps) || missingDeps.isEmpty()) {
                isChangeInDependency = true;
                this.coordAction.setMissingDependencies(nonExistListStr);
            }
            if (status && (pushDeps == null || pushDeps.length() == 0)) {
                String newActionXml = CoordActionInputCheckXCommand.resolveCoordConfiguration(actionXml, actionConf, this.actionId);
                actionXml.replace(0, actionXml.length(), newActionXml);
                this.coordAction.setActionXml(actionXml.toString());
                this.coordAction.setStatus(CoordinatorAction.Status.READY);
                this.updateCoordAction(this.coordAction, true);
                new CoordActionReadyXCommand(this.coordAction.getJobId()).call(this.getEntityKey());
            } else if (!this.isTimeout(currentTime)) {
                if (!status) {
                    this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()), this.getCoordInputCheckRequeueInterval());
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
            } else {
                if (!nonExistListStr.isEmpty() && pushDeps == null || pushDeps.length() == 0) {
                    this.queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                } else {
                    this.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId()));
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
            }
        }
        catch (Exception e) {
            if (this.isTimeout(currentTime)) {
                this.LOG.debug("Queueing timeout command");
                Services.get().get(CallableQueueService.class).queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
            }
            this.updateCoordAction(this.coordAction, isChangeInDependency);
            throw new CommandException(ErrorCode.E1021, e.getMessage(), e);
        }
        return null;
    }

    static String resolveCoordConfiguration(StringBuilder actionXml, Configuration actionConf, String actionId) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        ELEvaluator eval = CoordELEvaluator.createDataEvaluator(eAction, actionConf, actionId);
        CoordActionInputCheckXCommand.materializeDataProperties(eAction, actionConf, eval);
        return XmlUtils.prettyPrint(eAction).toString();
    }

    private boolean isTimeout(Date currentTime) {
        long waitingTime = (currentTime.getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
        int timeOut = this.coordAction.getTimeOut();
        return timeOut >= 0 && waitingTime > (long)timeOut;
    }

    private void updateCoordAction(CoordinatorActionBean coordAction, boolean isChangeInDependency) throws CommandException {
        coordAction.setLastModifiedTime(new Date());
        if (this.jpaService != null) {
            try {
                if (isChangeInDependency) {
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, coordAction);
                    if (EventHandlerService.isEnabled() && coordAction.getStatus() != CoordinatorAction.Status.READY) {
                        CoordActionInputCheckXCommand.generateEvent(coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), null);
                    }
                } else {
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_MODIFIED_DATE, coordAction);
                }
            }
            catch (JPAExecutorException jex) {
                throw new CommandException(ErrorCode.E1021, jex.getMessage(), jex);
            }
        }
    }

    public long getCoordInputCheckRequeueInterval() {
        long requeueInterval = Services.get().getConf().getLong(CONF_COORD_INPUT_CHECK_REQUEUE_INTERVAL, 60000L);
        return requeueInterval;
    }

    protected boolean checkInput(StringBuilder actionXml, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        return this.checkResolvedUris(eAction, existList, nonExistList, conf);
    }

    protected boolean checkUnResolvedInput(StringBuilder actionXml, Configuration conf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        this.LOG.debug("[" + this.actionId + "]::ActionInputCheck:: Checking Latest/future");
        boolean allExist = this.checkUnresolvedInstances(eAction, conf);
        if (allExist) {
            actionXml.replace(0, actionXml.length(), XmlUtils.prettyPrint(eAction).toString());
        }
        return allExist;
    }

    static void materializeDataProperties(Element eAction, Configuration conf, ELEvaluator eval) throws Exception {
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                CoordActionInputCheckXCommand.resolveTagContents("value", propElem, eval);
            }
        }
    }

    private static void resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws Exception {
        if (elem == null) {
            return;
        }
        Element tagElem = elem.getChild(tagName, elem.getNamespace());
        if (tagElem != null) {
            String updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText());
            tagElem.removeContent();
            tagElem.addContent(updated);
        } else {
            XLog.getLog(CoordActionInputCheckXCommand.class).warn(" Value NOT FOUND " + tagName);
        }
    }

    private boolean checkUnresolvedInstances(Element eAction, Configuration actionConf) throws Exception {
        boolean ret;
        String strAction = XmlUtils.prettyPrint(eAction).toString();
        Date nominalTime = DateUtils.parseDateOozieTZ(eAction.getAttributeValue("action-nominal-time"));
        String actualTimeStr = eAction.getAttributeValue("action-actual-time");
        Date actualTime = null;
        if (actualTimeStr == null) {
            this.LOG.debug("Unable to get action-actual-time from action xml, this job is submitted from previous version. Assign current date to actual time, action = " + this.actionId);
            actualTime = new Date();
        } else {
            actualTime = DateUtils.parseDateOozieTZ(actualTimeStr);
        }
        StringBuffer resultedXml = new StringBuffer();
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null && !(ret = this.materializeUnresolvedEvent(inputList.getChildren("data-in", eAction.getNamespace()), nominalTime, actualTime, actionConf))) {
            resultedXml.append(strAction);
            return false;
        }
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element dEvent : outputList.getChildren("data-out", eAction.getNamespace())) {
                if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
                throw new CommandException(ErrorCode.E1006, "coord:latest()/future()", " not permitted in output-event ");
            }
        }
        return true;
    }

    private boolean materializeUnresolvedEvent(List<Element> eDataEvents, Date nominalTime, Date actualTime, Configuration conf) throws Exception {
        for (Element dEvent : eDataEvents) {
            if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
            ELEvaluator eval = CoordELEvaluator.createLazyEvaluator(actualTime, nominalTime, dEvent, conf);
            String uresolvedInstance = dEvent.getChild("unresolved-instances", dEvent.getNamespace()).getTextTrim();
            String[] unresolvedList = uresolvedInstance.split("#");
            StringBuffer resolvedTmp = new StringBuffer();
            for (int i = 0; i < unresolvedList.length; ++i) {
                String ret = CoordELFunctions.evalAndWrap(eval, unresolvedList[i]);
                Boolean isResolved = (Boolean)eval.getVariable("is_resolved");
                if (!isResolved.booleanValue()) {
                    this.LOG.info("[" + this.actionId + "]::Cannot resolve: " + ret);
                    return false;
                }
                if (resolvedTmp.length() > 0) {
                    resolvedTmp.append("#");
                }
                resolvedTmp.append((String)eval.getVariable("resolved_path"));
            }
            if (resolvedTmp.length() > 0) {
                if (dEvent.getChild("uris", dEvent.getNamespace()) != null) {
                    resolvedTmp.append("#").append(dEvent.getChild("uris", dEvent.getNamespace()).getTextTrim());
                    dEvent.removeChild("uris", dEvent.getNamespace());
                }
                Element uriInstance = new Element("uris", dEvent.getNamespace());
                uriInstance.addContent(resolvedTmp.toString());
                dEvent.getContent().add(1, uriInstance);
            }
            dEvent.removeChild("unresolved-instances", dEvent.getNamespace());
        }
        return true;
    }

    private boolean checkResolvedUris(Element eAction, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null) {
            if (nonExistList.length() > 0) {
                this.checkListOfPaths(existList, nonExistList, conf);
            }
            return nonExistList.length() == 0;
        }
        return true;
    }

    private boolean checkListOfPaths(StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        String[] uriList = nonExistList.toString().split("#");
        if (uriList[0] != null) {
            this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: In checkListOfPaths: " + uriList[0] + " is Missing.");
        }
        nonExistList.delete(0, nonExistList.length());
        boolean allExists = true;
        String existSeparator = "";
        String nonExistSeparator = "";
        String user = ParamChecker.notEmpty(conf.get("user.name"), "user.name");
        for (int i = 0; i < uriList.length; ++i) {
            if (allExists) {
                allExists = this.pathExists(uriList[i], conf, user);
                this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: File:" + uriList[i] + ", Exists? :" + allExists);
            }
            if (allExists) {
                existList.append(existSeparator).append(uriList[i]);
                existSeparator = "#";
                continue;
            }
            nonExistList.append(nonExistSeparator).append(uriList[i]);
            nonExistSeparator = "#";
        }
        return allExists;
    }

    protected boolean pathExists(String sPath, Configuration actionConf, String user) throws IOException {
        this.LOG.debug("checking for the file " + sPath);
        try {
            URI uri = new URI(sPath);
            URIHandlerService service = Services.get().get(URIHandlerService.class);
            URIHandler handler = service.getURIHandler(uri);
            return handler.exists(uri, actionConf, user);
        }
        catch (URIHandlerException e) {
            this.coordAction.setErrorCode(e.getErrorCode().toString());
            this.coordAction.setErrorMessage(e.getMessage());
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            this.coordAction.setErrorCode(ErrorCode.E0906.toString());
            this.coordAction.setErrorMessage(e.getMessage());
            throw new IOException(e);
        }
    }

    private String createURIs(Element event, String instances, StringBuilder unresolvedInstances) throws Exception {
        if (instances == null || instances.length() == 0) {
            return "";
        }
        String[] instanceList = instances.split("#");
        StringBuilder uris = new StringBuilder();
        for (int i = 0; i < instanceList.length; ++i) {
            int funcType = CoordCommandUtils.getFuncType(instanceList[i]);
            if (funcType == CoordCommandUtils.LATEST || funcType == CoordCommandUtils.FUTURE) {
                if (unresolvedInstances.length() > 0) {
                    unresolvedInstances.append("#");
                }
                unresolvedInstances.append(instanceList[i]);
                continue;
            }
            ELEvaluator eval = CoordELEvaluator.createURIELEvaluator(instanceList[i]);
            if (uris.length() > 0) {
                uris.append("#");
            }
            uris.append(CoordELFunctions.evalAndWrap(eval, event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace()).getTextTrim()));
        }
        return uris.toString();
    }

    protected String getCoordActionErrorCode() {
        if (this.coordAction != null) {
            return this.coordAction.getErrorCode();
        }
        return null;
    }

    protected String getCoordActionErrorMsg() {
        if (this.coordAction != null) {
            return this.coordAction.getErrorMessage();
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        if (this.jpaService == null) {
            this.jpaService = Services.get().get(JPAService.class);
        }
        try {
            this.coordAction = this.jpaService.execute(new CoordActionGetForInputCheckJPAExecutor(this.actionId));
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_INPUT_CHECK, this.coordAction.getJobId());
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        LogUtils.setLogInfo(this.coordAction, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action. Should be in WAITING state, but state=" + this.coordAction.getStatus());
        }
        if (StatusUtils.getStatusForCoordActionInputCheck(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.RUNNINGWITHERROR && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action." + " Coordinator job is not in RUNNING/RUNNINGWITHERROR/PAUSED/PAUSEDWITHERROR state, but state=" + this.coordJob.getStatus());
        }
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

