/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.metaverse.api.model.BaseDatabaseResourceInfo;
import org.pentaho.metaverse.api.model.BaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.api.model.JdbcResourceInfo;
import org.pentaho.metaverse.api.model.JndiResourceInfo;
import org.pentaho.metaverse.api.model.WebServiceResourceInfo;

public class ExternalResourceInfoFactory {
    private static final boolean DEFAULT_IS_INPUT = true;

    protected ExternalResourceInfoFactory() {
    }

    public static IExternalResourceInfo createDatabaseResource(DatabaseMeta databaseMeta) {
        return ExternalResourceInfoFactory.createDatabaseResource(databaseMeta, true);
    }

    public static IExternalResourceInfo createDatabaseResource(DatabaseMeta databaseMeta, boolean isInput) {
        BaseDatabaseResourceInfo resourceInfo = "Native".equals(databaseMeta.getAccessTypeDesc()) ? new JdbcResourceInfo(databaseMeta) : new JndiResourceInfo(databaseMeta);
        resourceInfo.setInput(isInput);
        return resourceInfo;
    }

    public static IExternalResourceInfo createResource(ResourceEntry resourceEntry) {
        return ExternalResourceInfoFactory.createResource(resourceEntry, true);
    }

    public static IExternalResourceInfo createResource(ResourceEntry resourceEntry, boolean isInput) {
        BaseResourceInfo resourceInfo = new BaseResourceInfo();
        resourceInfo.setName(resourceEntry.getResource());
        resourceInfo.setInput(isInput);
        switch (resourceEntry.getResourcetype()) {
            case ACTIONFILE: 
            case FILE: {
                resourceInfo.setType("File");
                break;
            }
            case URL: {
                resourceInfo = (WebServiceResourceInfo)ExternalResourceInfoFactory.createURLResource(resourceEntry.getResource(), isInput);
                break;
            }
            case CONNECTION: 
            case DATABASENAME: {
                resourceInfo.setType("Database Connection");
                break;
            }
            case SERVER: {
                resourceInfo.setType("SERVER");
                break;
            }
            default: {
                resourceInfo.setType("OTHER");
            }
        }
        return resourceInfo;
    }

    public static IExternalResourceInfo createFileResource(FileObject fileObject) {
        return ExternalResourceInfoFactory.createFileResource(fileObject, true);
    }

    public static IExternalResourceInfo createFileResource(FileObject fileObject, boolean isInput) {
        BaseResourceInfo resource = null;
        if (fileObject != null) {
            resource = new BaseResourceInfo();
            resource.setName(fileObject.getName().getPath());
            resource.setInput(isInput);
            resource.setType("File");
        }
        return resource;
    }

    public static IExternalResourceInfo createURLResource(String url) {
        return ExternalResourceInfoFactory.createURLResource(url, true);
    }

    public static IExternalResourceInfo createURLResource(String url, boolean isInput) {
        WebServiceResourceInfo resource = null;
        if (url != null) {
            resource = new WebServiceResourceInfo();
            resource.setName(url);
            resource.setInput(isInput);
        }
        return resource;
    }
}

