/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DefaultAuthorizationProvider
extends AuthorizationProvider {
    @Override
    public void setUser(AuthorizationProvider.INodeAuthorizationInfo node, String user) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        int n = SerialNumberManager.INSTANCE.getUserSerialNumber(user);
        inode.updatePermissionStatus(INodeWithAdditionalFields.PermissionStatusFormat.USER, n);
    }

    @Override
    public String getUser(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        if (snapshotId != 0x7FFFFFFE) {
            return inode.getSnapshotINode(snapshotId).getUserName();
        }
        return INodeWithAdditionalFields.PermissionStatusFormat.getUser(inode.getPermissionLong());
    }

    @Override
    public void setGroup(AuthorizationProvider.INodeAuthorizationInfo node, String group) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        int n = SerialNumberManager.INSTANCE.getGroupSerialNumber(group);
        inode.updatePermissionStatus(INodeWithAdditionalFields.PermissionStatusFormat.GROUP, n);
    }

    @Override
    public String getGroup(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        if (snapshotId != 0x7FFFFFFE) {
            return inode.getSnapshotINode(snapshotId).getGroupName();
        }
        return INodeWithAdditionalFields.PermissionStatusFormat.getGroup(inode.getPermissionLong());
    }

    @Override
    public void setPermission(AuthorizationProvider.INodeAuthorizationInfo node, FsPermission permission) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        short mode = permission.toShort();
        inode.updatePermissionStatus(INodeWithAdditionalFields.PermissionStatusFormat.MODE, mode);
    }

    @Override
    public FsPermission getFsPermission(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        if (snapshotId != 0x7FFFFFFE) {
            return inode.getSnapshotINode(snapshotId).getFsPermission();
        }
        return new FsPermission(inode.getFsPermissionShort());
    }

    @Override
    public AclFeature getAclFeature(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        if (snapshotId != 0x7FFFFFFE) {
            return inode.getSnapshotINode(snapshotId).getFsimageAclFeature();
        }
        return (AclFeature)inode.getFeature(AclFeature.class);
    }

    @Override
    public void removeAclFeature(AuthorizationProvider.INodeAuthorizationInfo node) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        AclFeature f = inode.getFsimageAclFeature();
        Preconditions.checkNotNull((Object)f);
        inode.removeFeature(f);
    }

    @Override
    public void addAclFeature(AuthorizationProvider.INodeAuthorizationInfo node, AclFeature f) {
        INodeWithAdditionalFields inode = (INodeWithAdditionalFields)node;
        AclFeature f1 = inode.getFsimageAclFeature();
        if (f1 != null) {
            throw new IllegalStateException("Duplicated ACLFeature");
        }
        inode.addFeature(f);
    }

    private void checkAncestorType(INode[] inodes, int ancestorIndex, AccessControlException e) throws AccessControlException {
        for (int i = 0; i <= ancestorIndex && inodes[i] != null; ++i) {
            if (inodes[i].isDirectory()) continue;
            throw new AccessControlException(e.getMessage() + " (Ancestor " + inodes[i].getFullPathName() + " is not a directory).");
        }
        throw e;
    }

    @Override
    public void checkPermission(String user, Set<String> groups, AuthorizationProvider.INodeAuthorizationInfo[] nodes, int snapshotId, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException, UnresolvedLinkException {
        int ancestorIndex;
        INode[] inodes = (INode[])nodes;
        for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
        }
        try {
            this.checkTraverse(user, groups, inodes, ancestorIndex, snapshotId);
        }
        catch (AccessControlException e) {
            this.checkAncestorType(inodes, ancestorIndex, e);
        }
        INode last = inodes[inodes.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodes.length > 1 && last != null) {
            this.checkStickyBit(user, inodes[inodes.length - 2], last, snapshotId);
        }
        if (ancestorAccess != null && inodes.length > 1) {
            this.check(user, groups, inodes, ancestorIndex, snapshotId, ancestorAccess);
        }
        if (parentAccess != null && inodes.length > 1) {
            this.check(user, groups, inodes, inodes.length - 2, snapshotId, parentAccess);
        }
        if (access != null) {
            this.check(user, groups, last, snapshotId, access);
        }
        if (subAccess != null) {
            this.checkSubAccess(user, groups, last, snapshotId, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(user, last, snapshotId);
        }
    }

    private void checkOwner(String user, INode inode, int snapshotId) throws AccessControlException {
        if (inode == null || user.equals(inode.getUserName(snapshotId))) {
            return;
        }
        throw new AccessControlException("Permission denied. user=" + user + " is not the owner of inode=" + inode);
    }

    private void checkTraverse(String user, Set<String> groups, INode[] inodes, int last, int snapshotId) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(user, groups, inodes[j], snapshotId, FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(String user, Set<String> groups, INode inode, int snapshotId, FsAction access, boolean ignoreEmptyDir) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            ReadOnlyList<INode> cList = d.getChildrenList(snapshotId);
            if (!cList.isEmpty() || !ignoreEmptyDir) {
                this.check(user, groups, d, snapshotId, access);
            }
            for (INode child : cList) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(String user, Set<String> groups, INode[] inodes, int i, int snapshotId, FsAction access) throws AccessControlException {
        this.check(user, groups, i >= 0 ? inodes[i] : null, snapshotId, access);
    }

    private void check(String user, Set<String> groups, INode inode, int snapshotId, FsAction access) throws AccessControlException {
        int firstEntry;
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission(snapshotId);
        AclFeature aclFeature = inode.getAclFeature(snapshotId);
        if (aclFeature != null && AclEntryStatusFormat.getScope(firstEntry = aclFeature.getEntryAt(0)) == AclEntryScope.ACCESS) {
            this.checkAccessAcl(user, groups, inode, snapshotId, access, mode, aclFeature);
            return;
        }
        this.checkFsPermission(user, groups, inode, snapshotId, access, mode);
    }

    private void checkFsPermission(String user, Set<String> groups, INode inode, int snapshotId, FsAction access, FsPermission mode) throws AccessControlException {
        if (user.equals(inode.getUserName(snapshotId)) ? mode.getUserAction().implies(access) : (groups.contains(inode.getGroupName(snapshotId)) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(user, inode, snapshotId, access, mode));
    }

    private void checkAccessAcl(String user, Set<String> groups, INode inode, int snapshotId, FsAction access, FsPermission mode, AclFeature aclFeature) throws AccessControlException {
        boolean foundMatch = false;
        if (user.equals(inode.getUserName(snapshotId))) {
            if (mode.getUserAction().implies(access)) {
                return;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            int entry;
            for (int pos = 0; pos < aclFeature.getEntriesSize() && AclEntryStatusFormat.getScope(entry = aclFeature.getEntryAt(pos)) != AclEntryScope.DEFAULT; ++pos) {
                String group;
                AclEntryType type = AclEntryStatusFormat.getType(entry);
                String name = AclEntryStatusFormat.getName(entry);
                if (type == AclEntryType.USER) {
                    if (!user.equals(name)) continue;
                    FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP) continue;
                String string = group = name == null ? inode.getGroupName(snapshotId) : name;
                if (!groups.contains(group)) continue;
                FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return;
                }
                foundMatch = true;
            }
        }
        if (!foundMatch && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(user, inode, snapshotId, access, mode));
    }

    private void checkStickyBit(String user, INode parent, INode inode, int snapshotId) throws AccessControlException {
        if (!parent.getFsPermission(snapshotId).getStickyBit()) {
            return;
        }
        if (parent.getUserName(snapshotId).equals(user)) {
            return;
        }
        if (inode.getUserName(snapshotId).equals(user)) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + user + ", inode=" + inode);
    }

    private String toAccessControlString(String user, INode inode, int snapshotId, FsAction access, FsPermission mode) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(user).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(inode.getFullPathName()).append("\":").append(inode.getUserName(snapshotId)).append(':').append(inode.getGroupName(snapshotId)).append(':').append(inode.isDirectory() ? (char)'d' : '-').append(mode);
        return sb.toString();
    }
}

