/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.pigstats.ScriptState;

public class ATSService {
    private static final Log log = LogFactory.getLog((String)ATSService.class.getName());
    static ATSService instance;
    private static final Object LOCK;
    private static ExecutorService executor;
    private TimelineClient timelineClient;
    public static final String EntityType = "PIG_SCRIPT_ID";
    public static final String EntityCallerId = "callerId";
    public static final String CallerContext = "PIG";
    public static final int AUDIT_ID_MAX_LENGTH = 128;
    private static final int WAIT_TIME = 3;

    public static ATSService getInstance() {
        if (instance == null) {
            instance = new ATSService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ATSService() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ATS Logger %d").build());
                YarnConfiguration yarnConf = new YarnConfiguration();
                this.timelineClient = TimelineClient.createTimelineClient();
                this.timelineClient.init((Configuration)yarnConf);
                this.timelineClient.start();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        ATSService.this.timelineClient.stop();
                        executor.awaitTermination(3L, TimeUnit.SECONDS);
                        executor = null;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ATSService.this.timelineClient.stop();
                }
            });
        }
        log.info((Object)"Created ATS Hook");
    }

    public static String getPigAuditId(PigContext context) {
        String auditId;
        if (context.getProperties().get("pig.script.id") != null) {
            auditId = (String)context.getProperties().get("pig.script.id");
        } else {
            ScriptState ss = ScriptState.get();
            String filename = ss.getFileName().isEmpty() ? "default" : new File(ss.getFileName()).getName();
            auditId = "PIG-" + filename + "-" + ss.getId();
        }
        return auditId.substring(0, Math.min(auditId.length(), 128));
    }

    public synchronized void logEvent(final ATSEvent event) {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                TimelineEntity entity = new TimelineEntity();
                entity.setEntityId(event.pigScriptId);
                entity.setEntityType(ATSService.EntityType);
                entity.addPrimaryFilter(ATSService.EntityCallerId, (Object)(event.callerId != null ? event.callerId : "default"));
                try {
                    ATSService.this.timelineClient.putEntities(new TimelineEntity[]{entity});
                }
                catch (Exception e) {
                    log.info((Object)("Failed to submit plan to ATS: " + e.getMessage()));
                }
            }
        });
    }

    static {
        LOCK = new Object();
    }

    public static class ATSEvent {
        String callerId;
        String pigScriptId;

        public ATSEvent(String pigAuditId, String callerId) {
            this.pigScriptId = pigAuditId;
            this.callerId = callerId;
        }
    }
}

