/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.util.XLog;

public class Hive2Credentials
extends Credentials {
    private static final String USER_NAME = "user.name";
    private static final String HIVE2_JDBC_URL = "hive2.jdbc.url";
    private static final String HIVE2_SERVER_PRINCIPAL = "hive2.server.principal";

    @Override
    public void addtoJobConf(JobConf jobconf, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            String url = props.getProperties().get(HIVE2_JDBC_URL);
            if (url == null || url.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hive2.jdbc.url is required to get hive server 2 credential");
            }
            String principal = props.getProperties().get(HIVE2_SERVER_PRINCIPAL);
            if (principal == null || principal.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hive2.server.principal is required to get hive server 2 credential");
            }
            url = url + ";principal=" + principal;
            Connection con = DriverManager.getConnection(url);
            XLog.getLog(this.getClass()).debug("Connected successfully to " + url);
            String tokenStr = ((HiveConnection)con).getDelegationToken(jobconf.get(USER_NAME), principal);
            XLog.getLog(this.getClass()).debug("Got token");
            con.close();
            Token hive2Token = new Token();
            hive2Token.decodeFromUrlString(tokenStr);
            jobconf.getCredentials().addToken(new Text("hive.server2.delegation.token"), hive2Token);
            XLog.getLog(this.getClass()).debug("Added the Hive Server 2 token in job conf");
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in addtoJobConf", e);
            throw e;
        }
    }
}

