/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.exceloutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutput;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class ExcelOutputExternalResourceConsumer
extends BaseStepExternalResourceConsumer<ExcelOutput, ExcelOutputMeta> {
    public Collection<IExternalResourceInfo> getResourcesFromMeta(ExcelOutputMeta meta, IAnalysisContext context) {
        String[] paths;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!this.isDataDriven((BaseStepMeta)meta) && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (paths = meta.getFiles((VariableSpace)parentTransMeta)) != null) {
            resources = new ArrayList<IExternalResourceInfo>(paths.length);
            for (String path : paths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource((FileObject)KettleVFS.getFileObject((String)path), (boolean)false);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(ExcelOutput excelOutput, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        try {
            String filename = excelOutput.buildFilename();
            if (!Const.isEmpty((String)filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)filename);
                resources.add(ExternalResourceInfoFactory.createFileResource((FileObject)fileObject, (boolean)false));
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }

    public Class<ExcelOutputMeta> getMetaClass() {
        return ExcelOutputMeta.class;
    }
}

