/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.streamlookup;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLookupStepAnalyzer
extends StepAnalyzer<StreamLookupMeta> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepAnalyzer.class);
    protected String[] keyLookups;
    protected String[] keyStreams;
    protected String[] values;
    protected String[] valueNames;
    protected String lookupStep;

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(StreamLookupMeta.class);
        return set;
    }

    public Map<String, RowMetaInterface> getInputFields(StreamLookupMeta meta) {
        Map rowMeta = super.getInputFields((BaseStepMeta)meta);
        if (this.parentTransMeta != null) {
            for (String prevStepName : this.parentTransMeta.getPrevStepNames(this.parentStepMeta)) {
                if (rowMeta.containsKey(prevStepName)) continue;
                try {
                    rowMeta.put(prevStepName, this.parentTransMeta.getStepFields(prevStepName));
                }
                catch (KettleStepException e) {
                    LOGGER.warn(Messages.getString("WARNING.CannotDetermineRowMeta", prevStepName, e.toString()));
                }
            }
        }
        return rowMeta;
    }

    protected Set<StepField> getUsedFields(StreamLookupMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        this.keyLookups = meta.getKeylookup();
        this.keyStreams = meta.getKeystream();
        this.values = meta.getValue();
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        this.lookupStep = ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(0)).getStepname();
        for (int i = 0; i < this.keyLookups.length; ++i) {
            String leftField = this.keyStreams[i];
            String rightField = this.keyLookups[i];
            usedFields.add(new StepField(prevStepNames[0], leftField));
            usedFields.add(new StepField(this.lookupStep, rightField));
        }
        for (String retrieveField : this.values) {
            usedFields.add(new StepField(this.lookupStep, retrieveField));
        }
        return usedFields;
    }

    protected void customAnalyze(StreamLookupMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        this.keyLookups = meta.getKeylookup();
        this.keyStreams = meta.getKeystream();
        this.values = meta.getValue();
        this.valueNames = meta.getValueName();
        this.lookupStep = ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(0)).getStepname();
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        for (int i = 0; i < this.keyLookups.length; ++i) {
            IMetaverseNode keyNode = this.getInputs().findNode(prevStepNames[0], this.keyStreams[i]);
            IMetaverseNode keyLookupNode = this.getInputs().findNode(this.lookupStep, this.keyLookups[i]);
            this.metaverseBuilder.addLink(keyLookupNode, "joins", keyNode);
            this.metaverseBuilder.addLink(keyNode, "joins", keyLookupNode);
        }
    }

    public Set<ComponentDerivationRecord> getChangeRecords(StreamLookupMeta meta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        String[] names = meta.getValue();
        String[] newFields = meta.getValueName();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String newFieldName = newFields[i];
            if (this.newFieldNameExistsInMainInputStream(newFieldName)) {
                RowMetaInterface outputFields = this.getOutputFields((BaseStepMeta)meta);
                for (int renameIdx = 1; renameIdx <= this.valueNames.length; ++renameIdx) {
                    ValueMetaInterface outField = outputFields.searchValueMeta(newFieldName + "_" + renameIdx);
                    if (outField != null) continue;
                    newFieldName = newFieldName + "_" + renameIdx;
                    break;
                }
            }
            ComponentDerivationRecord renameFieldRecord = new ComponentDerivationRecord(name, newFieldName, ChangeType.METADATA);
            renameFieldRecord.addOperation(Operation.getRenameOperation());
            changeRecords.add(renameFieldRecord);
        }
        return changeRecords;
    }

    protected boolean newFieldNameExistsInMainInputStream(String newFieldName) {
        if (this.parentTransMeta != null) {
            String lookupStepName = ((StreamInterface)((StreamLookupMeta)this.baseStepMeta).getStepIOMeta().getInfoStreams().get(0)).getStepname();
            String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.parentStepMeta);
            for (int i = 0; i < prevStepNames.length; ++i) {
                String prevStepName = prevStepNames[i];
                if (prevStepName.equals(lookupStepName)) continue;
                try {
                    RowMetaInterface stepFields = this.parentTransMeta.getStepFields(prevStepName);
                    if (stepFields != null) {
                        ValueMetaInterface valueMetaInterface = stepFields.searchValueMeta(newFieldName);
                        return valueMetaInterface != null;
                    }
                    continue;
                }
                catch (KettleStepException e) {
                    LOGGER.warn(Messages.getString("WARNING.CannotDetermineRowMeta", prevStepName, e.toString()));
                }
            }
        }
        return false;
    }

    protected void setStepMeta(StreamLookupMeta meta) {
        this.baseStepMeta = meta;
    }

    protected void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    protected void setParentStepMeta(StepMeta parentStepMeta) {
        this.parentStepMeta = parentStepMeta;
    }
}

