/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.pen.Illustrable;
import org.apache.pig.pen.Illustrator;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

public class Packager
implements Illustrable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected boolean[] readOnce;
    protected DataBag[] bags;
    protected transient Illustrator illustrator = null;
    Object key;
    protected boolean isKeyTuple = false;
    protected boolean isKeyCompound = false;
    byte keyType;
    int numInputs;
    boolean useSecondaryKey = false;
    boolean[] inner;
    protected boolean distinct = false;
    protected Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo;
    private PackageType pkgType;
    private transient boolean initialized;
    private transient boolean useDefaultBag;
    protected POPackage parent = null;
    protected static final BagFactory mBagFactory = BagFactory.getInstance();
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();

    public Object getKey(PigNullableWritable key) throws ExecException {
        Object keyObject = key.getValueAsPigType();
        if (this.useSecondaryKey) {
            return ((Tuple)keyObject).get(0);
        }
        return keyObject;
    }

    public void attachInput(Object key, DataBag[] bags, boolean[] readOnce) throws ExecException {
        this.checkBagType();
        this.key = key;
        this.bags = bags;
        this.readOnce = readOnce;
        for (int i = 0; i < bags.length; ++i) {
            if (!readOnce[i]) continue;
            DataBag materializedBag = this.getBag();
            materializedBag.addAll(bags[i]);
            bags[i] = materializedBag;
        }
    }

    public Result getNext() throws ExecException {
        Tuple res;
        if (this.bags == null) {
            return new Result(3, null);
        }
        if (this.isDistinct()) {
            res = mTupleFactory.newTuple(1);
            res.set(0, this.key);
        } else {
            res = mTupleFactory.newTuple(this.numInputs + 1);
            res.set(0, this.key);
            int i = -1;
            for (DataBag bag : this.bags) {
                if (this.inner[++i] && bag.size() == 0L) {
                    this.detachInput();
                    Result r = new Result();
                    r.returnStatus = 1;
                    return r;
                }
                res.set(i + 1, bag);
            }
        }
        Result r = new Result();
        r.returnStatus = 0;
        r.result = this.illustratorMarkup(null, res, 0);
        this.detachInput();
        return r;
    }

    public void detachInput() {
        this.key = null;
        this.bags = null;
    }

    protected Tuple illustratorMarkup2(Object in, Object out) {
        if (this.illustrator != null) {
            ExampleTuple tOut = !(out instanceof ExampleTuple) ? new ExampleTuple((Tuple)out) : (ExampleTuple)out;
            this.illustrator.getLineage().insert(tOut);
            tOut.synthetic = ((ExampleTuple)in).synthetic;
            this.illustrator.getLineage().union(tOut, (Tuple)in);
            return tOut;
        }
        return (Tuple)out;
    }

    protected Tuple starMarkup(Tuple key, Tuple val, Tuple out) {
        if (this.illustrator != null) {
            Tuple copy = this.illustratorMarkup2(key, out);
            if (this.isDistinct()) {
                copy = this.illustratorMarkup2(val, out);
            }
            return copy;
        }
        return out;
    }

    public Tuple getValueTuple(PigNullableWritable keyWritable, NullableTuple ntup, int index) throws ExecException {
        Object key = this.getKey(keyWritable);
        Tuple val = (Tuple)ntup.getValueAsPigType();
        Tuple copy = null;
        Pair<Boolean, Map<Integer, Integer>> lrKeyInfo = this.keyInfo.get(index);
        boolean isProjectStar = (Boolean)lrKeyInfo.first;
        Map keyLookup = (Map)lrKeyInfo.second;
        int keyLookupSize = keyLookup.size();
        if (keyLookupSize > 0) {
            int finalValueSize = keyLookupSize + val.size();
            copy = mTupleFactory.newTuple(finalValueSize);
            int valIndex = 0;
            for (int i = 0; i < finalValueSize; ++i) {
                Integer keyIndex = (Integer)keyLookup.get(i);
                if (keyIndex == null) {
                    copy.set(i, val.get(valIndex));
                    ++valIndex;
                    continue;
                }
                if (this.isKeyTuple && this.isKeyCompound) {
                    copy.set(i, ((Tuple)key).get(keyIndex));
                    continue;
                }
                copy.set(i, key);
            }
            copy = this.illustratorMarkup2(val, copy);
        } else if (isProjectStar) {
            copy = mTupleFactory.newTuple(((Tuple)key).getAll());
            copy = this.starMarkup((Tuple)key, val, copy);
        } else {
            copy = mTupleFactory.newTuple(val.getAll());
            copy = this.illustratorMarkup2(val, copy);
        }
        return copy;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        this.keyType = keyType;
    }

    public boolean getKeyTuple() {
        return this.isKeyTuple;
    }

    public Tuple getKeyAsTuple() {
        return this.isKeyTuple ? (Tuple)this.key : null;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean[] getInner() {
        return this.inner;
    }

    public void setInner(boolean[] inner) {
        this.inner = inner;
    }

    public void setKeyInfo(Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setKeyTuple(boolean keyTuple) {
        this.isKeyTuple = keyTuple;
    }

    public void setKeyCompound(boolean keyCompound) {
        this.isKeyCompound = keyCompound;
    }

    public Map<Integer, Pair<Boolean, Map<Integer, Integer>>> getKeyInfo() {
        return this.keyInfo;
    }

    public Illustrator getIllustrator() {
        return this.illustrator;
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    public void setPackageType(PackageType type) {
        this.pkgType = type;
    }

    public PackageType getPackageType() {
        return this.pkgType;
    }

    public int getNumInputs(byte index) {
        return this.numInputs;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public void setNumInputs(int numInputs) {
        this.numInputs = numInputs;
    }

    public Packager clone() throws CloneNotSupportedException {
        Packager clone = (Packager)super.clone();
        clone.setNumInputs(this.numInputs);
        clone.setPackageType(this.pkgType);
        clone.setDistinct(this.distinct);
        if (this.inner != null) {
            clone.inner = new boolean[this.inner.length];
            for (int i = 0; i < this.inner.length; ++i) {
                clone.inner[i] = this.inner[i];
            }
        } else {
            clone.inner = null;
        }
        if (this.keyInfo != null) {
            clone.setKeyInfo(new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>(this.keyInfo));
        }
        clone.setKeyCompound(this.isKeyCompound);
        clone.setKeyTuple(this.isKeyTuple);
        clone.setKeyType(this.keyType);
        clone.setUseSecondaryKey(this.useSecondaryKey);
        return clone;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            int i;
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            LineageTracer lineageTracer = this.illustrator.getLineage();
            lineageTracer.insert(tOut);
            boolean synthetic = false;
            if (this.illustrator.getEquivalenceClasses() == null) {
                LinkedList<IdentityHashSet<Tuple>> equivalenceClasses = new LinkedList<IdentityHashSet<Tuple>>();
                for (i = 0; i < this.numInputs; ++i) {
                    IdentityHashSet equivalenceClass = new IdentityHashSet();
                    equivalenceClasses.add(equivalenceClass);
                }
                this.illustrator.setEquivalenceClasses(equivalenceClasses, this.parent);
            }
            if (this.isDistinct()) {
                int count = 0;
                for (Tuple tmp : this.bags[0]) {
                    ++count;
                    if (tmp.equals(tOut)) continue;
                    lineageTracer.union(tOut, tmp);
                }
                if (count > 1) {
                    this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tOut);
                }
                this.illustrator.addData(tOut);
                return tOut;
            }
            boolean outInEqClass = true;
            try {
                for (i = 1; i < this.numInputs + 1; ++i) {
                    DataBag dbs = (DataBag)((Tuple)out).get(i);
                    Iterator<Tuple> iter = dbs.iterator();
                    if (dbs.size() <= 1L && outInEqClass) {
                        outInEqClass = false;
                    }
                    while (iter.hasNext()) {
                        Tuple tmp = iter.next();
                        if (!synthetic && ((ExampleTuple)tmp).synthetic) {
                            synthetic = true;
                        }
                        lineageTracer.union(tOut, tmp);
                    }
                }
            }
            catch (ExecException e) {
                throw new RuntimeException("Illustrator exception :" + e.getMessage());
            }
            if (outInEqClass) {
                this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tOut);
            }
            tOut.synthetic = synthetic;
            this.illustrator.addData(tOut);
            return tOut;
        }
        return (Tuple)out;
    }

    public void setParent(POPackage pack) {
        this.parent = pack;
    }

    public int numberOfEquivalenceClasses() {
        return 1;
    }

    public void checkBagType() {
        if (!this.initialized) {
            String bagType;
            this.initialized = true;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                this.useDefaultBag = true;
            }
        }
    }

    public DataBag getBag() {
        return this.useDefaultBag ? mBagFactory.newDefaultBag() : new InternalCachedBag(this.numInputs);
    }

    public static enum PackageType {
        GROUP,
        JOIN;

    }
}

