/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DBSplitter;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import com.cloudera.sqoop.mapreduce.db.OracleDataDrivenDBRecordReader;
import com.cloudera.sqoop.mapreduce.db.OracleDateSplitter;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.sqoop.mapreduce.DBWritable;

public class OracleDataDrivenDBInputFormat<T extends DBWritable>
extends DataDrivenDBInputFormat<T>
implements Configurable {
    @Override
    protected DBSplitter getSplitter(int sqlDataType, long splitLimit) {
        switch (sqlDataType) {
            case 91: 
            case 92: 
            case 93: {
                return new OracleDateSplitter();
            }
        }
        return super.getSplitter(sqlDataType, splitLimit);
    }

    @Override
    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        DBConfiguration dbConf = this.getDBConf();
        Class<?> inputClass = dbConf.getInputClass();
        try {
            return new OracleDataDrivenDBRecordReader(split, inputClass, conf, this.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName());
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }
}

