/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.controller;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.IUIAbsRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.model.UIAbsSecurity;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.controller.EESecurityController;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityManager;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Element;

public class AbsController
extends EESecurityController
implements Serializable {
    private static final long serialVersionUID = -9005536054475853743L;
    protected boolean initialized = false;
    private static final Class<?> PKG = IUIAbsRole.class;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };
    private XulButton applyLogicalRolesButton;
    private XulButton applyLogicalSystemRolesButton;
    private XulVbox logicalRolesBox;
    private XulVbox logicalSystemRolesBox;
    private XulListbox roleListBox;
    private XulListbox systemRoleListBox;
    Map<XulCheckbox, String> logicalRoleChecboxMap = new HashMap<XulCheckbox, String>();
    Map<XulCheckbox, String> logicalSystemRoleChecboxMap = new HashMap<XulCheckbox, String>();
    private BindingConvertor<Integer, Boolean> buttonConverter;
    private UIAbsSecurity absSecurity;

    @Override
    protected boolean initService() {
        try {
            String localeValue;
            if (this.repository.hasService(IAbsSecurityManager.class)) {
                this.service = (RepositorySecurityManager)this.repository.getService(IAbsSecurityManager.class);
                localeValue = null;
                try {
                    localeValue = GlobalMessages.getLocale().getDisplayName();
                }
                catch (MissingResourceException e) {
                    try {
                        localeValue = LanguageChoice.getInstance().getFailoverLocale().getDisplayName();
                    }
                    catch (MissingResourceException e2) {
                        localeValue = "en_US";
                    }
                }
            } else {
                return false;
            }
            ((IAbsSecurityManager)this.service).initialize(localeValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    protected void setInitialDeck() {
        super.setInitialDeck();
        this.initializeLogicalRolesUI();
        this.initializeLogicalSystemRolesUI();
    }

    @Override
    protected void createSecurity() throws Exception {
        this.absSecurity = new UIAbsSecurity(this.service);
        this.eeSecurity = this.absSecurity;
        this.security = this.absSecurity;
    }

    @Override
    protected void createBindings() {
        super.createBindings();
        this.roleListBox = (XulListbox)this.document.getElementById("roles-list");
        this.systemRoleListBox = (XulListbox)this.document.getElementById("system-roles-list");
        this.applyLogicalRolesButton = (XulButton)this.document.getElementById("apply-action-permission");
        this.applyLogicalSystemRolesButton = (XulButton)this.document.getElementById("apply-system-role-action-permission");
        this.logicalRolesBox = (XulVbox)this.document.getElementById("role-action-permissions-vbox");
        this.logicalSystemRolesBox = (XulVbox)this.document.getElementById("system-role-action-permissions-vbox");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.buttonConverter = new BindingConvertor<Integer, Boolean>(){

            public Boolean sourceToTarget(Integer value) {
                if (value != null && value >= 0) {
                    return false;
                }
                return true;
            }

            public Integer targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.createBinding((Object)this.roleListBox, "selectedIndex", (Object)this.applyLogicalRolesButton, "disabled", new BindingConvertor[]{this.buttonConverter});
        this.bf.createBinding((Object)this.systemRoleListBox, "selectedIndex", (Object)this.applyLogicalSystemRolesButton, "disabled", new BindingConvertor[]{this.buttonConverter});
        this.bf.createBinding((Object)this.absSecurity, "selectedRole", (Object)this, "selectedRoleChanged", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.absSecurity, "selectedSystemRole", (Object)this, "selectedSystemRoleChanged", new BindingConvertor[0]);
    }

    public void updateRoleActionPermission() {
        for (Map.Entry<XulCheckbox, String> currentEntry : this.logicalRoleChecboxMap.entrySet()) {
            XulCheckbox permissionCheckbox = currentEntry.getKey();
            if (permissionCheckbox.isChecked()) {
                this.absSecurity.addLogicalRole(currentEntry.getValue());
                continue;
            }
            this.absSecurity.removeLogicalRole(currentEntry.getValue());
        }
    }

    public void updateSystemRoleActionPermission() {
        for (Map.Entry<XulCheckbox, String> currentEntry : this.logicalSystemRoleChecboxMap.entrySet()) {
            XulCheckbox permissionCheckbox = currentEntry.getKey();
            if (permissionCheckbox.isChecked()) {
                this.absSecurity.addLogicalRole(currentEntry.getValue());
                continue;
            }
            this.absSecurity.removeLogicalRole(currentEntry.getValue());
        }
    }

    public void applyRoleActionPermission() {
        XulMessageBox messageBox = this.getMessageBox();
        IUIRole role = null;
        IUIAbsRole absRole = null;
        try {
            role = this.absSecurity.getSelectedRole();
            if (!(role instanceof IUIAbsRole)) {
                throw new IllegalStateException();
            }
            absRole = (IUIAbsRole)role;
            ((IAbsSecurityManager)this.service).setLogicalRoles(absRole.getName(), absRole.getLogicalRoles());
            messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
            messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"AbsController.RoleActionPermission.Success", (String[])new String[0]));
            messageBox.open();
            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CHANGED);
        }
        catch (KettleException e) {
            messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"AbsController.RoleActionPermission.UnableToApplyPermissions", (String[])new String[]{role.getName(), e.getLocalizedMessage()}));
            messageBox.open();
        }
    }

    public void applySystemRoleActionPermission() {
        XulMessageBox messageBox = this.getMessageBox();
        IUIRole role = null;
        IUIAbsRole absRole = null;
        try {
            role = this.absSecurity.getSelectedSystemRole();
            if (!(role instanceof IUIAbsRole)) {
                throw new IllegalStateException();
            }
            absRole = (IUIAbsRole)role;
            ((IAbsSecurityManager)this.service).setLogicalRoles(absRole.getName(), absRole.getLogicalRoles());
            messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
            messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"AbsController.RoleActionPermission.Success", (String[])new String[0]));
            messageBox.open();
            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CHANGED);
        }
        catch (KettleException e) {
            messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"AbsController.RoleActionPermission.UnableToApplyPermissions", (String[])new String[]{role.getName(), e.getLocalizedMessage()}));
            messageBox.open();
        }
    }

    public void setSelectedRoleChanged(IUIRole role) throws Exception {
        IUIAbsRole absRole = null;
        this.uncheckAllActionPermissions();
        if (role instanceof IUIAbsRole) {
            absRole = (IUIAbsRole)role;
            if (absRole != null && absRole.getLogicalRoles() != null) {
                for (String permission : absRole.getLogicalRoles()) {
                    XulCheckbox permissionCheckbox = this.findRoleCheckbox(permission);
                    if (permissionCheckbox == null) continue;
                    permissionCheckbox.setChecked(true);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void setSelectedSystemRoleChanged(IUIRole role) throws Exception {
        IUIAbsRole absRole = null;
        this.uncheckAllSystemActionPermissions();
        if (role instanceof IUIAbsRole) {
            absRole = (IUIAbsRole)role;
            if (absRole != null && absRole.getLogicalRoles() != null) {
                for (String permission : absRole.getLogicalRoles()) {
                    XulCheckbox permissionCheckbox = this.findSystemRoleCheckbox(permission);
                    if (permissionCheckbox == null) continue;
                    permissionCheckbox.setChecked(true);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private XulCheckbox findRoleCheckbox(String permission) {
        for (Map.Entry<XulCheckbox, String> currentEntry : this.logicalRoleChecboxMap.entrySet()) {
            if (!currentEntry.getValue().equals(permission)) continue;
            return currentEntry.getKey();
        }
        return null;
    }

    private XulCheckbox findSystemRoleCheckbox(String permission) {
        for (Map.Entry<XulCheckbox, String> currentEntry : this.logicalSystemRoleChecboxMap.entrySet()) {
            if (!currentEntry.getValue().equals(permission)) continue;
            return currentEntry.getKey();
        }
        return null;
    }

    private void initializeLogicalRolesUI() {
        try {
            Map<String, String> logicalRoles = ((IAbsSecurityManager)this.service).getAllLogicalRoles(GlobalMessages.getLocale().getDisplayName());
            for (Map.Entry<String, String> logicalRole : logicalRoles.entrySet()) {
                XulCheckbox logicalRoleCheckbox = (XulCheckbox)this.document.createElement("checkbox");
                logicalRoleCheckbox.setLabel(logicalRole.getValue());
                logicalRoleCheckbox.setId(logicalRole.getValue());
                logicalRoleCheckbox.setCommand("iSecurityController.updateRoleActionPermission()");
                logicalRoleCheckbox.setFlex(1);
                logicalRoleCheckbox.setDisabled(true);
                this.logicalRolesBox.addChild((Element)logicalRoleCheckbox);
                this.logicalRoleChecboxMap.put(logicalRoleCheckbox, logicalRole.getKey());
                this.bf.setBindingType(Binding.Type.ONE_WAY);
                this.bf.createBinding((Object)this.roleListBox, "selectedIndex", (Object)logicalRoleCheckbox, "disabled", new BindingConvertor[]{this.buttonConverter});
            }
        }
        catch (XulException xulException) {
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
    }

    private void initializeLogicalSystemRolesUI() {
        try {
            Map<String, String> logicalRoles = ((IAbsSecurityManager)this.service).getAllLogicalRoles(GlobalMessages.getLocale().getDisplayName());
            for (Map.Entry<String, String> logicalRole : logicalRoles.entrySet()) {
                XulCheckbox logicalSystemRoleCheckbox = (XulCheckbox)this.document.createElement("checkbox");
                logicalSystemRoleCheckbox.setLabel(logicalRole.getValue());
                logicalSystemRoleCheckbox.setId(logicalRole.getValue());
                logicalSystemRoleCheckbox.setCommand("iSecurityController.updateSystemRoleActionPermission()");
                logicalSystemRoleCheckbox.setFlex(1);
                logicalSystemRoleCheckbox.setDisabled(true);
                this.logicalSystemRolesBox.addChild((Element)logicalSystemRoleCheckbox);
                this.logicalSystemRoleChecboxMap.put(logicalSystemRoleCheckbox, logicalRole.getKey());
                this.bf.setBindingType(Binding.Type.ONE_WAY);
                this.bf.createBinding((Object)this.systemRoleListBox, "selectedIndex", (Object)logicalSystemRoleCheckbox, "disabled", new BindingConvertor[]{this.buttonConverter});
            }
        }
        catch (XulException xulException) {
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
    }

    private void uncheckAllActionPermissions() {
        for (XulCheckbox permissionCheckbox : this.logicalRoleChecboxMap.keySet()) {
            permissionCheckbox.setChecked(false);
        }
    }

    private void uncheckAllSystemActionPermissions() {
        for (XulCheckbox permissionCheckbox : this.logicalSystemRoleChecboxMap.keySet()) {
            permissionCheckbox.setChecked(false);
        }
    }
}

