/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;

public final class BarcodeImageHandler {
    private static Set formats;

    public static Set getImageFormats() {
        return formats;
    }

    private BarcodeImageHandler() {
    }

    public static BufferedImage getImage(Barcode barcode) throws OutputException {
        BufferedImage bufferedImage = new BufferedImage(barcode.getWidth(), barcode.getHeight(), 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        barcode.draw(graphics2D, 0, 0);
        bufferedImage.flush();
        return bufferedImage;
    }

    public static void writeJPEG(Barcode barcode, OutputStream outputStream) throws OutputException {
        BarcodeImageHandler.writeImage(barcode, "jpeg", outputStream);
    }

    public static void saveJPEG(Barcode barcode, File file) throws OutputException {
        BarcodeImageHandler.saveImage(barcode, "jpeg", file);
    }

    public static void savePNG(Barcode barcode, File file) throws OutputException {
        BarcodeImageHandler.saveImage(barcode, "png", file);
    }

    public static void saveGIF(Barcode barcode, File file) throws OutputException {
        BarcodeImageHandler.saveImage(barcode, "gif", file);
    }

    private static void saveImage(Barcode barcode, String string, File file) throws OutputException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            BarcodeImageHandler.writeImage(barcode, string, fileOutputStream);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new OutputException(iOException);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writePNG(Barcode barcode, OutputStream outputStream) throws OutputException {
        BarcodeImageHandler.writeImage(barcode, "png", outputStream);
    }

    public static void writeGIF(Barcode barcode, OutputStream outputStream) throws OutputException {
        BarcodeImageHandler.writeImage(barcode, "gif", outputStream);
    }

    private static void writeImage(Barcode barcode, String string, OutputStream outputStream) throws OutputException {
        BufferedImage bufferedImage = BarcodeImageHandler.getImage(barcode);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            throw new OutputException("exception while writing image", iOException);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("gif");
        hashSet.add("jpeg");
        hashSet.add("png");
        formats = Collections.unmodifiableSet(hashSet);
    }
}

