/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.process.Processable;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PentahoHadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;
import org.pentaho.hadoop.shim.spi.SnappyShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HadoopConfiguration {
    private static final Class<?> PKG = HadoopConfiguration.class;
    private String identifier;
    private String name;
    private FileObject location;
    private HadoopShim hadoopShim;
    private List<PentahoHadoopShim> availableShims;
    private Properties configProperties;

    public HadoopConfiguration(FileObject location, String identifier, String name, HadoopShim hadoopShim, PentahoHadoopShim ... shims) {
        this(new Properties(), location, identifier, name, hadoopShim, shims);
    }

    public HadoopConfiguration(Properties configProperties, FileObject location, String identifier, String name, HadoopShim hadoopShim, PentahoHadoopShim ... shims) {
        if (location == null || identifier == null || name == null || hadoopShim == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.identifier = identifier;
        this.name = name;
        this.hadoopShim = hadoopShim;
        this.configProperties = configProperties;
        this.availableShims = new ArrayList<PentahoHadoopShim>();
        this.availableShims.add(hadoopShim);
        for (PentahoHadoopShim shim : shims) {
            if (shim == null) continue;
            this.availableShims.add(shim);
        }
    }

    public Properties getConfigProperties() {
        return this.configProperties;
    }

    public FileObject getLocation() {
        return this.location;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public HadoopShim getHadoopShim() {
        return this.getWrappedHadoopShim();
    }

    private HadoopShim getWrappedHadoopShim() {
        return (HadoopShim)Proxy.newProxyInstance(this.hadoopShim.getClass().getClassLoader(), new Class[]{HadoopShim.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("submitJob")) {
                    HadoopConfiguration.this.process((Configuration)args[0]);
                }
                return method.invoke((Object)HadoopConfiguration.this.hadoopShim, args);
            }
        });
    }

    public SqoopShim getSqoopShim() throws ConfigurationException {
        return this.getShim(SqoopShim.class);
    }

    public PigShim getPigShim() throws ConfigurationException {
        return this.getShim(PigShim.class);
    }

    public SnappyShim getSnappyShim() throws ConfigurationException {
        return this.getShim(SnappyShim.class);
    }

    public <T extends PentahoHadoopShim> T getShim(Class<T> shimType) throws ConfigurationException {
        for (PentahoHadoopShim shim : this.availableShims) {
            if (!shimType.isAssignableFrom(shim.getClass())) continue;
            PentahoHadoopShim t = shim;
            return (T)t;
        }
        throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.UnsupportedShim", (String[])new String[]{this.getName(), shimType.getSimpleName()}));
    }

    public HBaseShim getHBaseShim() throws ConfigurationException {
        return this.getShim(HBaseShim.class);
    }

    public String toString() {
        return this.getIdentifier();
    }

    public List<PentahoHadoopShim> getAvailableShims() {
        return this.availableShims;
    }

    public void process(Configuration configuration) {
        for (PentahoHadoopShim shim : this.getAvailableShims()) {
            if (!Processable.class.isInstance(shim)) continue;
            Processable processable = (Processable)((Object)shim);
            processable.process(configuration);
        }
    }
}

