/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown.devtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.FormulaLinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.PatternLinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.devtools.AbstractDrillDownEditor;
import org.pentaho.reporting.engine.classic.extensions.drilldown.devtools.FormulaDrillDownEditor;
import org.pentaho.reporting.engine.classic.extensions.drilldown.devtools.PatternDrillDownEditor;
import org.pentaho.reporting.engine.classic.extensions.drilldown.parser.DrillDownProfileCollection;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DrillDownProfileEditor
extends CommonDialog {
    private static final Log logger = LogFactory.getLog(DrillDownProfileEditor.class);
    private DefaultListModel drillDownProfiles;
    private JList profileList;

    public DrillDownProfileEditor() {
        this.init();
    }

    public DrillDownProfileEditor(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public DrillDownProfileEditor(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected String getDialogId() {
        return "extensions.drilldown.DrillDownProfileEditor";
    }

    protected Component createContentPane() {
        this.drillDownProfiles = new DefaultListModel();
        this.profileList = new JList(this.drillDownProfiles);
        this.profileList.setCellRenderer(new DrillDownProfileListRenderer());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 5, 5));
        buttonPane.add(new JButton(new NewAction()));
        buttonPane.add(new JButton(new EditAction()));
        buttonPane.add(new JButton(new RemoveAction()));
        buttonPane.add(Box.createHorizontalStrut(10));
        buttonPane.add(new JButton(new LoadAction()));
        buttonPane.add(new JButton(new SaveAction()));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)buttonPane, "North");
        contentPane.add((Component)new JScrollPane(this.profileList), "Center");
        return contentPane;
    }

    public void load(File file) {
        try {
            ResourceManager resourceManager = new ResourceManager();
            Resource resource = resourceManager.createDirectly((Object)file, DrillDownProfileCollection.class);
            DrillDownProfileCollection typeCollection = (DrillDownProfileCollection)resource.getResource();
            DrillDownProfile[] types = typeCollection.getData();
            for (int i = 0; i < types.length; ++i) {
                DrillDownProfile metaData = types[i];
                if (metaData == null) continue;
                this.drillDownProfiles.addElement(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
        }
    }

    public DrillDownProfile edit(DrillDownProfile profile) {
        AbstractDrillDownEditor drillDownEditor;
        if (PatternLinkCustomizer.class.isAssignableFrom(profile.getLinkCustomizerType())) {
            drillDownEditor = new PatternDrillDownEditor((Dialog)((Object)this));
        } else if (FormulaLinkCustomizer.class.isAssignableFrom(profile.getLinkCustomizerType())) {
            drillDownEditor = new FormulaDrillDownEditor((Dialog)((Object)this));
        } else {
            return profile;
        }
        return drillDownEditor.performEdit(profile);
    }

    public void create() {
        int retval = JOptionPane.showOptionDialog((Component)((Object)this), "Select link customizer type", "Select Link Customizer Type", 2, -1, null, new Class[]{FormulaLinkCustomizer.class, PatternLinkCustomizer.class}, FormulaLinkCustomizer.class);
        if (retval == 0) {
            this.drillDownProfiles.addElement(new DrillDownProfile(FormulaLinkCustomizer.class));
        } else if (retval == 1) {
            this.drillDownProfiles.addElement(new DrillDownProfile(PatternLinkCustomizer.class));
        }
    }

    public void save(File file) {
        try {
            DefaultTagDescription tags = new DefaultTagDescription();
            tags.setDefaultNamespace("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0");
            tags.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", false);
            tags.setElementHasCData("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "attribute", true);
            XmlWriter w = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), (TagDescription)tags);
            w.writeXmlDeclaration("UTF-8");
            AttributeList rootList = new AttributeList();
            rootList.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0");
            w.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "drilldown-profiles", rootList, false);
            Object[] objects = this.drillDownProfiles.toArray();
            for (int i = 0; i < objects.length; ++i) {
                DrillDownProfile object = (DrillDownProfile)((Object)objects[i]);
                AttributeList profileAttrs = new AttributeList();
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "name", object.getName());
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "class", object.getLinkCustomizerType().getName());
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "bundle-name", object.getBundleLocation());
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "expert", String.valueOf(object.isExpert()));
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "hidden", String.valueOf(object.isHidden()));
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "deprecated", String.valueOf(object.isDeprecated()));
                profileAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "preferred", String.valueOf(object.isPreferred()));
                w.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "drilldown-profile", profileAttrs, false);
                String[] attrNames = object.getAttributes();
                for (int j = 0; j < attrNames.length; ++j) {
                    String attrName = attrNames[j];
                    String attrValue = object.getAttribute(attrName);
                    w.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0", "attribute", "name", attrName, false);
                    w.writeTextNormalized(attrValue, false);
                    w.writeCloseTag();
                }
                w.writeCloseTag();
            }
            w.writeCloseTag();
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        DrillDownProfileEditor editor = new DrillDownProfileEditor();
        editor.pack();
        LibSwingUtil.centerFrameOnScreen((Window)((Object)editor));
        editor.setVisible(true);
    }

    private static class DrillDownProfileListRenderer
    extends DefaultListCellRenderer {
        private DrillDownProfileListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DrillDownProfile) {
                DrillDownProfile profile = (DrillDownProfile)((Object)value);
                String valueText = String.format("%s", profile.getName());
                return super.getListCellRendererComponent((JList<?>)list, valueText, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private SaveAction() {
            this.putValue("Name", "Save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonFileChooser chooser = FileChooserService.getInstance().getFileChooser("drilldown-profiles");
            if (!chooser.showDialog((Component)((Object)DrillDownProfileEditor.this), 1)) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                DrillDownProfileEditor.this.save(selectedFile);
            }
        }
    }

    private class LoadAction
    extends AbstractAction {
        private LoadAction() {
            this.putValue("Name", "Load");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonFileChooser chooser = FileChooserService.getInstance().getFileChooser("drilldown-profiles");
            if (!chooser.showDialog((Component)((Object)DrillDownProfileEditor.this), 0)) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                DrillDownProfileEditor.this.load(selectedFile);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
            this.putValue("Name", "Edit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownProfile o = (DrillDownProfile)((Object)DrillDownProfileEditor.this.profileList.getSelectedValue());
            if (o == null) {
                return;
            }
            DrillDownProfile drillDownProfile = DrillDownProfileEditor.this.edit(o);
            if (drillDownProfile == o) {
                return;
            }
            int i = DrillDownProfileEditor.this.drillDownProfiles.indexOf((Object)o);
            DrillDownProfileEditor.this.drillDownProfiles.removeElement((Object)o);
            DrillDownProfileEditor.this.drillDownProfiles.add(i, drillDownProfile);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("Name", "Remove");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownProfile o = (DrillDownProfile)((Object)DrillDownProfileEditor.this.profileList.getSelectedValue());
            if (o == null) {
                return;
            }
            DrillDownProfileEditor.this.drillDownProfiles.removeElement((Object)o);
        }
    }

    private class NewAction
    extends AbstractAction {
        private NewAction() {
            this.putValue("Name", "New");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownProfileEditor.this.create();
        }
    }
}

