/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulProgressmeter;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;

public class SwtProgressmeter
extends SwtElement
implements XulProgressmeter {
    protected ProgressBar progressmeter;
    private boolean indeterminate;
    protected XulComponent parent;
    private int initialValue;
    private int initialMaximum;
    private int initialMinimum;

    public SwtProgressmeter(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.parent = parent;
    }

    protected ProgressBar createNewProgressmeter(Composite parent) {
        ProgressBar progressmeter = new ProgressBar(parent, this.isIndeterminate() ? 2 : 0);
        progressmeter.setSelection(this.initialValue);
        progressmeter.setMinimum(this.initialMinimum);
        progressmeter.setMaximum(this.initialMaximum);
        return progressmeter;
    }

    public int getMaximum() {
        return this.progressmeter.getMaximum();
    }

    public int getMinimum() {
        return this.progressmeter.getMinimum();
    }

    public int getValue() {
        return this.progressmeter.getSelection();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
    }

    public void setMaximum(int value) {
        if (null != this.progressmeter) {
            this.progressmeter.setMaximum(value);
        } else {
            this.initialMaximum = value;
        }
    }

    public void setMinimum(int value) {
        if (null != this.progressmeter) {
            this.progressmeter.setMinimum(value);
        } else {
            this.initialMinimum = value;
        }
    }

    public void setMode(String mode) {
        this.indeterminate = "undetermined".equals(mode);
    }

    public void setValue(final int value) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (null != SwtProgressmeter.this.progressmeter) {
                    SwtProgressmeter.this.progressmeter.setSelection(value);
                } else {
                    SwtProgressmeter.this.initialValue = value;
                }
            }
        });
    }

    @Override
    public void layout() {
        this.progressmeter = this.createNewProgressmeter((Composite)this.parent.getManagedObject());
        this.setManagedObject(this.progressmeter);
    }
}

