/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class FindOldestProcessKeyStep
extends IterateSimpleStructureProcessStep {
    private ReportStateKey key;
    private boolean finishedPaginate;

    public ReportStateKey find(RenderBox box) {
        if (box.isProcessKeyCacheValid()) {
            return box.getProcessKeyCached();
        }
        this.key = null;
        this.finishedPaginate = box.isFinishedPaginate();
        this.startProcessing(box);
        box.setProcessKeyCached(this.key);
        return this.key;
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        ReportStateKey stateKey = node.getStateKey();
        if (stateKey == null || stateKey.isInlineSubReportState()) {
            return;
        }
        if (this.key == null) {
            this.key = stateKey;
            return;
        }
        if (stateKey.getSequenceCounter() > this.key.getSequenceCounter()) {
            this.key = stateKey;
        }
    }

    @Override
    protected boolean startBox(RenderBox box) {
        if (box.isProcessKeyCacheValid()) {
            this.key = box.getProcessKeyCached();
            return false;
        }
        this.processOtherNode(box);
        if (this.finishedPaginate) {
            box.setFinishedPaginate(true);
        }
        return true;
    }

    @Override
    protected void finishBox(RenderBox box) {
        box.setProcessKeyCached(this.key);
    }
}

