/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ValidationResult;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;

public class ValidateModelStep
extends IterateStructuralProcessStep {
    private static final Log logger = LogFactory.getLog(ValidateModelStep.class);
    private ValidationResult result;
    private TableValidationInfo validationInfo;

    public boolean isLayoutable(LogicalPageBox root) {
        this.validationInfo = null;
        this.setResult(ValidationResult.OK);
        this.processBoxChilds(root);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validation result: " + (Object)((Object)this.getResult())));
        }
        return this.getResult() == ValidationResult.OK;
    }

    public void setResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.setResult(box.isValidateModelResult());
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Canvas: Box is open: " + box));
            }
            this.setResult(ValidationResult.CANVAS_BOX_OPEN);
            box.setValidateModelResult(this.getResult());
            return false;
        }
        return box.getAppliedContentRefCount() != 0 || box.getTableRefCount() != 0;
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    protected boolean validateBlockOrAutoBox(RenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.setResult(box.isValidateModelResult());
            return false;
        }
        if (box.isOpen()) {
            if (box.getNext() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Box is open with next element pending : " + box));
                }
                this.setResult(ValidationResult.BOX_OPEN_NEXT_PENDING);
                box.setValidateModelResult(this.getResult());
                return false;
            }
            if (box.getStaticBoxLayoutProperties().isPlaceholderBox()) {
                if (box.getFirstChild() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Block: Open Box is placeholder : " + box));
                    }
                    this.setResult(ValidationResult.PLACEHOLDER_BOX_OPEN);
                    box.setValidateModelResult(this.getResult());
                    return false;
                }
            } else if (box.getNodeType() == 274) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Paragraph is open: " + box));
                }
                this.setResult(ValidationResult.PARAGRAPH_BOX_OPEN);
                box.setValidateModelResult(this.getResult());
                return false;
            }
        } else if (box.getAppliedContentRefCount() == 0 && box.getTableRefCount() == 0) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.validateBlockOrAutoBox(box);
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        if ((box.getLayoutNodeType() & 0x12) == 18) {
            return this.validateBlockOrAutoBox(box);
        }
        if ((box.getLayoutNodeType() & 0x41002) == 266242 || (box.getLayoutNodeType() & 0x42002) == 270338) {
            return true;
        }
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    private boolean validateInlineRowOrTableCellBox(RenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return false;
        }
        if (box.isValidateModelCacheValid()) {
            this.setResult(box.isValidateModelResult());
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inline: Box is open : " + box));
            }
            this.setResult(ValidationResult.CELL_BOX_OPEN);
            box.setValidateModelResult(this.getResult());
            return false;
        }
        return box.getAppliedContentRefCount() != 0 || box.getTableRefCount() != 0;
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        int rowSpan = box.getRowSpan();
        this.validationInfo.seenTableCell(rowSpan);
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.validateInlineRowOrTableCellBox(box);
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        if (this.getResult() != ValidationResult.OK) {
            return;
        }
        box.setValidateModelResult(this.getResult());
    }

    @Override
    protected boolean startTableBox(TableRenderBox table) {
        this.validationInfo = new TableValidationInfo(this.validationInfo);
        if (this.getResult() != ValidationResult.OK) {
            return false;
        }
        if (table.isValidateModelCacheValid()) {
            this.setResult(table.isValidateModelResult());
            return true;
        }
        if (table.isOpen()) {
            if (table.isAutoLayout()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Table: Open Table and AutoLayout: " + table));
                }
                this.setResult(ValidationResult.TABLE_BOX_OPEN);
                table.setValidateModelResult(this.getResult());
                return false;
            }
            if (!table.getColumnModel().isIncrementalModeSupported()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Table: Open Table and incremental mode not supported: " + table));
                }
                this.setResult(ValidationResult.TABLE_BOX_OPEN);
                table.setValidateModelResult(this.getResult());
                return false;
            }
            if (table.isPreventPagination()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Table: Open Table and incremental mode not supported: " + table));
                }
                this.setResult(ValidationResult.TABLE_BOX_PREVENTS_PAGINATION);
                table.setValidateModelResult(this.getResult());
                return false;
            }
        }
        this.validationInfo.setNeedCheck(true);
        return true;
    }

    @Override
    protected void finishTableBox(TableRenderBox table) {
        try {
            if (table.isValidateModelCacheValid()) {
                return;
            }
            if (this.getResult() != ValidationResult.OK) {
                return;
            }
            if (!this.validationInfo.isNeedCheck()) {
                return;
            }
            if (table.isOpen() && !this.validationInfo.isSeenTableBody() && !this.validationInfo.isSeenRowInMainBody()) {
                this.setResult(ValidationResult.TABLE_BOX_MISSING_DATA);
                table.setValidateModelResult(this.getResult());
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Table-Box: " + this.validationInfo));
            }
            table.setValidateModelResult(this.getResult());
        }
        finally {
            this.validationInfo = this.validationInfo.pop();
        }
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
            this.validationInfo.setInMainBody(true);
        }
        this.validationInfo.startTableSection(true);
        return true;
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        if (box.isOpen() && this.validationInfo.isRequireAdditionalRows()) {
            this.setResult(ValidationResult.TABLE_BODY_MISSING_ROWS);
            box.setValidateModelResult(this.getResult());
        }
        this.validationInfo.setInMainBody(false);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox row) {
        if (row.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Table-Row: Box is open.");
            }
            this.setResult(ValidationResult.TABLE_ROW_OPEN);
            row.setValidateModelResult(this.getResult());
            return false;
        }
        this.validationInfo.addSeenRow();
        return true;
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        this.validationInfo.rowFinished();
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return this.getResult() == ValidationResult.OK;
    }

    protected ValidationResult getResult() {
        return this.result;
    }

    private static class TableValidationInfo {
        private boolean needCheck;
        private boolean seenBody;
        private int seenRow;
        private int requiredAdditionalRows;
        private int currentRowMaxRowSpan;
        private boolean inMainBody;
        private boolean seenRowInMainBody;
        private TableValidationInfo parent;

        private TableValidationInfo(TableValidationInfo parent) {
            this.parent = parent;
            this.requiredAdditionalRows = 0;
        }

        public TableValidationInfo pop() {
            return this.parent;
        }

        public void setInMainBody(boolean inMainBody) {
            this.requiredAdditionalRows = 0;
            this.inMainBody = inMainBody;
        }

        public boolean isRequireAdditionalRows() {
            return this.requiredAdditionalRows > 0;
        }

        public boolean isNeedCheck() {
            return this.needCheck;
        }

        public void setNeedCheck(boolean needCheck) {
            this.needCheck = needCheck;
        }

        public boolean isSeenTableBody() {
            return this.seenBody;
        }

        public void startTableSection(boolean seenBody) {
            this.requiredAdditionalRows = 0;
            this.seenBody = seenBody;
        }

        public boolean isSeenRowInMainBody() {
            return this.seenRowInMainBody;
        }

        public void addSeenRow() {
            if (this.inMainBody) {
                this.seenRowInMainBody = true;
            }
            ++this.seenRow;
            this.currentRowMaxRowSpan = 0;
            if (this.requiredAdditionalRows > 0) {
                --this.requiredAdditionalRows;
            }
        }

        public void rowFinished() {
            this.requiredAdditionalRows += this.currentRowMaxRowSpan;
            --this.requiredAdditionalRows;
        }

        public void seenTableCell(int rowSpan) {
            this.currentRowMaxRowSpan = Math.max(rowSpan, this.currentRowMaxRowSpan);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TableValidationInfo");
            sb.append("{needCheck=").append(this.needCheck);
            sb.append(", seenBody=").append(this.seenBody);
            sb.append(", seenRow=").append(this.seenRow);
            sb.append(", inMainBody=").append(this.inMainBody);
            sb.append(", parent=").append(this.parent);
            sb.append('}');
            return sb.toString();
        }
    }
}

