/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.DefaultParameterComponentFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;

public class DropDownParameterComponent
extends JComboBox
implements ParameterComponent {
    private ListParameter listParameter;
    private ParameterUpdateContext updateContext;
    private ParameterContext parameterContext;
    private boolean adjustingToExternalInput;

    public DropDownParameterComponent(ListParameter listParameter, ParameterUpdateContext updateContext, ParameterContext parameterContext) {
        if (listParameter == null) {
            throw new NullPointerException();
        }
        if (updateContext == null) {
            throw new NullPointerException();
        }
        if (parameterContext == null) {
            throw new NullPointerException();
        }
        this.listParameter = listParameter;
        this.updateContext = updateContext;
        this.parameterContext = parameterContext;
        this.addActionListener(new SingleValueListParameterHandler(listParameter.getName()));
        updateContext.addChangeListener(new ComboBoxUpdateHandler());
    }

    @Override
    public void initialize() throws ReportDataFactoryException {
        this.adjustingToExternalInput = true;
        try {
            KeyedComboBoxModel<Object, Object> keyedComboBoxModel = DefaultParameterComponentFactory.createModel(this.listParameter, this.parameterContext);
            Object value = this.updateContext.getParameterValue(this.listParameter.getName());
            this.setSelectedValue(value, keyedComboBoxModel);
            this.setModel(keyedComboBoxModel);
        }
        finally {
            this.adjustingToExternalInput = false;
        }
    }

    private void setSelectedValue(Object key, KeyedComboBoxModel<Object, Object> model) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            BigDecimal bdV;
            BigDecimal bdK;
            Object value = model.getKeyAt(i);
            if (key == value) {
                model.setSelectedKey(value);
                return;
            }
            if (key != null && key.equals(value)) {
                model.setSelectedKey(value);
                return;
            }
            if (key instanceof Number && value instanceof Number && (bdK = new BigDecimal(key.toString())).compareTo(bdV = new BigDecimal(value.toString())) == 0) {
                model.setSelectedKey(value);
                return;
            }
            if (!(key instanceof Date) || !(value instanceof Date)) continue;
            Date d1 = (Date)key;
            Date d2 = (Date)value;
            if (d1.getTime() != d2.getTime()) continue;
            model.setSelectedKey(value);
            return;
        }
        model.setSelectedKey(null);
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    private class SingleValueListParameterHandler
    implements ActionListener {
        private String key;

        public SingleValueListParameterHandler(String key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DropDownParameterComponent.this.adjustingToExternalInput) {
                return;
            }
            Object theSource = e.getSource();
            if (theSource instanceof JComboBox) {
                JComboBox theComboBox = (JComboBox)theSource;
                KeyedComboBoxModel theModel = (KeyedComboBoxModel)theComboBox.getModel();
                DropDownParameterComponent.this.updateContext.setParameterValue(this.key, theModel.getSelectedKey());
            }
        }
    }

    private class ComboBoxUpdateHandler
    implements ChangeListener {
        private ComboBoxUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                DropDownParameterComponent.this.initialize();
            }
            catch (ReportDataFactoryException rdfe) {
                throw new IndexOutOfBoundsException("Failed: " + rdfe.getMessage());
            }
        }
    }
}

