/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.beans.IntrospectionException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.FormulaFunction;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertiesReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ExpressionReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String DEPENCY_LEVEL_ATT = "deplevel";
    private String originalClassName;
    private String expressionClassName;
    private Expression expression;

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        int depLevel = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), DEPENCY_LEVEL_ATT), (int)0);
        String expressionName = attrs.getValue(this.getUri(), "name");
        String className = attrs.getValue(this.getUri(), "class");
        String formula = attrs.getValue(this.getUri(), "formula");
        if (className == null) {
            String initial = attrs.getValue(this.getUri(), "initial");
            if (initial != null) {
                FormulaFunction function = new FormulaFunction();
                function.setInitial(initial);
                function.setFormula(formula);
                this.expression = function;
                this.expression.setName(expressionName);
                this.expression.setDependencyLevel(depLevel);
                this.originalClassName = FormulaFunction.class.getName();
                this.expressionClassName = FormulaFunction.class.getName();
            } else {
                FormulaExpression expression = new FormulaExpression();
                expression.setFormula(formula);
                this.expression = expression;
                this.expression.setName(expressionName);
                this.expression.setDependencyLevel(depLevel);
                this.originalClassName = FormulaExpression.class.getName();
                this.expressionClassName = FormulaExpression.class.getName();
            }
        }
        if (this.expression == null && className != null) {
            String mappedName = CompatibilityMapperUtil.mapClassName(className);
            this.expression = (Expression)ObjectUtilities.loadAndInstantiate((String)mappedName, ((Object)((Object)this)).getClass(), Expression.class);
            if (this.expression == null) {
                throw new ParseException("Expression '" + className + "' is not valid.", this.getLocator());
            }
            this.expression.setName(expressionName);
            this.expression.setDependencyLevel(depLevel);
            this.originalClassName = className;
            this.expressionClassName = mappedName;
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("properties".equals(tagName) && this.expression != null) {
            try {
                return new ExpressionPropertiesReadHandler(this.expression, this.originalClassName, this.expressionClassName);
            }
            catch (IntrospectionException e) {
                throw new ParseException("Unable to create Introspector for the specified expression.", this.getLocator());
            }
        }
        return null;
    }

    public Object getObject() {
        return this.expression;
    }
}

