/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class FsActionExecutor
extends ActionExecutor {
    public FsActionExecutor() {
        super("fs");
    }

    Path getPath(Element element, String attribute) {
        String str = element.getAttributeValue(attribute).trim();
        return new Path(str);
    }

    void validatePath(Path path, boolean withScheme) throws ActionExecutorException {
        String scheme = path.toUri().getScheme();
        if (withScheme) {
            if (scheme == null) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS001", "Missing scheme in path [{0}]", path);
            }
            if (!scheme.equals("hdfs")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS002", "Scheme [{0}] not supported in path [{1}]", scheme, path);
            }
        } else if (scheme != null) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS003", "Scheme [{0}] not allowed in path [{1}]", scheme, path);
        }
    }

    void validateSameNN(Path source, Path dest) throws ActionExecutorException {
        String s;
        Path destPath = new Path(source, dest);
        String t = destPath.toUri().getScheme() + destPath.toUri().getAuthority();
        if (!t.equals(s = source.toUri().getScheme() + source.toUri().getAuthority())) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS007", "move, target NN URI different from that of source", dest);
        }
    }

    void doOperations(ActionExecutor.Context context, Element element) throws ActionExecutorException {
        try {
            FileSystem fs = context.getAppFileSystem();
            boolean recovery = fs.exists(this.getRecoveryPath(context));
            if (!recovery) {
                fs.mkdirs(this.getRecoveryPath(context));
            }
            for (Element commandElement : element.getChildren()) {
                Path path;
                String command = commandElement.getName();
                if (command.equals("mkdir")) {
                    path = this.getPath(commandElement, "path");
                    this.mkdir(context, path);
                    continue;
                }
                if (command.equals("delete")) {
                    path = this.getPath(commandElement, "path");
                    this.delete(context, path);
                    continue;
                }
                if (command.equals("move")) {
                    Path source = this.getPath(commandElement, "source");
                    Path target = this.getPath(commandElement, "target");
                    this.move(context, source, target, recovery);
                    continue;
                }
                if (!command.equals("chmod")) continue;
                path = this.getPath(commandElement, "path");
                String str = commandElement.getAttributeValue("dir-files");
                boolean dirFiles = str == null || Boolean.parseBoolean(str);
                String permissionsMask = commandElement.getAttributeValue("permissions").trim();
                this.chmod(context, path, permissionsMask, dirFiles);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private FileSystem getFileSystemFor(Path path, ActionExecutor.Context context) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        String group = context.getWorkflow().getGroup();
        return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), new Configuration());
    }

    private FileSystem getFileSystemFor(Path path, String user, String group) throws HadoopAccessorException {
        return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), new Configuration());
    }

    void mkdir(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        try {
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, context);
            if (!fs.exists(path) && !fs.mkdirs(path)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS004", "mkdir, path [{0}] could not create directory", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void delete(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        try {
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, context);
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void delete(String user, String group, Path path) throws ActionExecutorException {
        try {
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, user, group);
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void move(ActionExecutor.Context context, Path source, Path target, boolean recovery) throws ActionExecutorException {
        try {
            this.validatePath(source, true);
            this.validateSameNN(source, target);
            FileSystem fs = this.getFileSystemFor(source, context);
            if (!fs.exists(source) && !recovery) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS006", "move, source path [{0}] does not exist", source);
            }
            if (!fs.rename(source, target) && !recovery) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS008", "move, could not move [{0}] to [{1}]", source, target);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void chmod(ActionExecutor.Context context, Path path, String permissions, boolean dirFiles) throws ActionExecutorException {
        try {
            Path[] paths;
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, context);
            if (!fs.exists(path)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS009", "chmod, path [{0}] does not exist", path);
            }
            FileStatus pathStatus = fs.getFileStatus(path);
            if (dirFiles && pathStatus.isDir()) {
                FileStatus[] filesStatus = fs.listStatus(path);
                paths = new Path[filesStatus.length];
                for (int i = 0; i < filesStatus.length; ++i) {
                    paths[i] = filesStatus[i].getPath();
                }
            } else {
                paths = new Path[]{path};
            }
            FsPermission newFsPermission = this.createShortPermission(permissions, path);
            fs.setPermission(path, newFsPermission);
            for (Path p : paths) {
                fs.setPermission(p, newFsPermission);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    FsPermission createShortPermission(String permissions, Path path) throws ActionExecutorException {
        if (permissions.length() == 3) {
            char user = permissions.charAt(0);
            char group = permissions.charAt(1);
            char other = permissions.charAt(2);
            int useri = user - 48;
            int groupi = group - 48;
            int otheri = other - 48;
            int mask = useri * 100 + groupi * 10 + otheri;
            short omask = Short.parseShort(Integer.toString(mask), 8);
            return new FsPermission(omask);
        }
        if (permissions.length() == 10) {
            return FsPermission.valueOf((String)permissions);
        }
        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS010", "chmod, path [{0}] invalid permissions mask [{1}]", path, permissions);
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            context.setStartData("-", "-", "-");
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.doOperations(context, actionXml);
            context.setExecutionData("OK", null);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = externalStatus.equals("OK") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        context.setEndData(status, this.getActionSignal(status));
        if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false)) {
            try {
                FileSystem fs = context.getAppFileSystem();
                fs.delete(context.getActionDir(), true);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    public Path getRecoveryPath(ActionExecutor.Context context) throws HadoopAccessorException, IOException, URISyntaxException {
        return new Path(context.getActionDir(), "fs-" + context.getRecoveryId());
    }
}

