/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.AbstractList;
import java.util.List;
import java.util.ListIterator;
import mondrian.calc.TupleList;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Member;
import mondrian.olap.QueryAxis;
import mondrian.olap4j.MondrianOlap4jCellSet;
import mondrian.rolap.RolapAxis;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.Position;

class MondrianOlap4jCellSetAxis
implements CellSetAxis {
    private final MondrianOlap4jCellSet olap4jCellSet;
    private final QueryAxis queryAxis;
    private final RolapAxis axis;

    MondrianOlap4jCellSetAxis(MondrianOlap4jCellSet olap4jCellSet, QueryAxis queryAxis, RolapAxis axis) {
        assert (olap4jCellSet != null);
        assert (queryAxis != null);
        assert (axis != null);
        this.olap4jCellSet = olap4jCellSet;
        this.queryAxis = queryAxis;
        this.axis = axis;
    }

    public Axis getAxisOrdinal() {
        return Axis.Factory.forOrdinal((int)this.queryAxis.getAxisOrdinal().logicalOrdinal());
    }

    public CellSet getCellSet() {
        return this.olap4jCellSet;
    }

    public CellSetAxisMetaData getAxisMetaData() {
        AxisOrdinal axisOrdinal = this.queryAxis.getAxisOrdinal();
        if (axisOrdinal.isFilter()) {
            return this.olap4jCellSet.getMetaData().getFilterAxisMetaData();
        }
        return (CellSetAxisMetaData)this.olap4jCellSet.getMetaData().getAxesMetaData().get(axisOrdinal.logicalOrdinal());
    }

    public List<Position> getPositions() {
        return new AbstractList<Position>(){

            @Override
            public Position get(int index) {
                return new MondrianOlap4jPosition(MondrianOlap4jCellSetAxis.this.axis.getTupleList(), index);
            }

            @Override
            public int size() {
                return MondrianOlap4jCellSetAxis.this.axis.getTupleList().size();
            }
        };
    }

    public int getPositionCount() {
        return this.getPositions().size();
    }

    public ListIterator<Position> iterator() {
        return this.getPositions().listIterator();
    }

    private class MondrianOlap4jPosition
    implements Position {
        private final TupleList tupleList;
        private final int index;

        public MondrianOlap4jPosition(TupleList tupleList, int index) {
            this.tupleList = tupleList;
            this.index = index;
        }

        public List<org.olap4j.metadata.Member> getMembers() {
            return new AbstractList<org.olap4j.metadata.Member>(){

                @Override
                public org.olap4j.metadata.Member get(int slice) {
                    Member mondrianMember = MondrianOlap4jPosition.this.tupleList.get(slice, MondrianOlap4jPosition.this.index);
                    return ((MondrianOlap4jCellSetAxis)MondrianOlap4jCellSetAxis.this).olap4jCellSet.olap4jStatement.olap4jConnection.toOlap4j(mondrianMember);
                }

                @Override
                public int size() {
                    return MondrianOlap4jPosition.this.tupleList.getArity();
                }
            };
        }

        public int getOrdinal() {
            return this.index;
        }
    }
}

