/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;

public class BeanInjector {
    private final BeanInjectionInfo info;

    public BeanInjector(BeanInjectionInfo info) {
        this.info = info;
    }

    public Object getProperty(Object root, String propName) throws Exception {
        ArrayList extractedIndexes = new ArrayList();
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        Object obj = root;
        int arrIndex = 0;
        block4: for (int i = 1; i < prop.path.size(); ++i) {
            BeanLevelInfo s = prop.path.get(i);
            if ((obj = s.field.get(obj)) == null) {
                return null;
            }
            switch (s.dim) {
                case ARRAY: {
                    int indexArray = (Integer)extractedIndexes.get(arrIndex++);
                    if (Array.getLength(obj) <= indexArray) {
                        return null;
                    }
                    if ((obj = Array.get(obj, indexArray)) != null) continue block4;
                    return null;
                }
                case LIST: {
                    int indexList = (Integer)extractedIndexes.get(arrIndex++);
                    List list = (List)obj;
                    if (list.size() <= indexList) {
                        return null;
                    }
                    obj = list.get(indexList);
                    if (obj != null) continue block4;
                    return null;
                }
            }
        }
        return obj;
    }

    public boolean hasProperty(Object root, String propName) {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        return prop != null;
    }

    public void setProperty(Object root, String propName, List<RowMetaAndData> data, String dataName) throws KettleException {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new KettleException("Property '" + propName + "' not found for injection to " + root.getClass());
        }
        if (prop.pathArraysCount == 0) {
            try {
                this.setProperty(root, prop, 0, data.get(0), dataName);
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount == 1) {
            try {
                for (int i = 0; i < data.size(); ++i) {
                    this.setProperty(root, prop, i, data.get(i), dataName);
                }
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount > 1) {
            throw new KettleException("Property '" + propName + "' has more than one array in path for injection to " + root.getClass());
        }
    }

    private void setProperty(Object root, BeanInjectionInfo.Property prop, int index, RowMetaAndData data, String dataName) throws Exception {
        Object obj = root;
        for (int i = 1; i < prop.path.size(); ++i) {
            Object value;
            List<Object> existList;
            Object existArray;
            BeanLevelInfo s = prop.path.get(i);
            if (i < prop.path.size() - 1) {
                switch (s.dim) {
                    case ARRAY: {
                        existArray = this.extendArray(s, obj, index + 1);
                        Object next = Array.get(existArray, index);
                        if (next == null) {
                            next = this.createObject(s.leafClass, root);
                            Array.set(existArray, index, next);
                        }
                        obj = next;
                        break;
                    }
                    case LIST: {
                        existList = this.extendList(s, obj, index + 1);
                        Object next = existList.get(index);
                        if (next == null) {
                            next = this.createObject(s.leafClass, root);
                            existList.set(index, next);
                        }
                        obj = next;
                        break;
                    }
                    case NONE: {
                        Object next;
                        if (s.field != null) {
                            next = s.field.get(obj);
                            if (next == null) {
                                next = this.createObject(s.leafClass, root);
                                s.field.set(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        if (s.getter != null) {
                            next = s.getter.invoke(obj, new Object[0]);
                            if (next == null) {
                                if (s.setter == null) {
                                    throw new KettleException("No setter defined for " + root.getClass());
                                }
                                next = s.leafClass.newInstance();
                                s.setter.invoke(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        throw new KettleException("No field or getter defined for " + root.getClass());
                    }
                }
                continue;
            }
            if (!s.convertEmpty && data.isEmptyValue(dataName)) {
                return;
            }
            if (s.setter != null) {
                value = data.getAsJavaType(dataName, s.leafClass, s.converter);
                s.setter.invoke(obj, value);
                continue;
            }
            if (s.field != null) {
                switch (s.dim) {
                    case ARRAY: {
                        existArray = this.extendArray(s, obj, index + 1);
                        value = data.getAsJavaType(dataName, s.leafClass, s.converter);
                        Array.set(existArray, index, value);
                        break;
                    }
                    case LIST: {
                        existList = this.extendList(s, obj, index + 1);
                        value = data.getAsJavaType(dataName, s.leafClass, s.converter);
                        existList.set(index, value);
                        break;
                    }
                    case NONE: {
                        value = data.getAsJavaType(dataName, s.leafClass, s.converter);
                        s.field.set(obj, value);
                    }
                }
                continue;
            }
            throw new KettleException("No field or setter defined for " + root.getClass());
        }
    }

    private Object createObject(Class<?> clazz, Object root) throws KettleException {
        try {
            for (Constructor<?> c : clazz.getConstructors()) {
                if (c.getParameterTypes().length == 0) {
                    return clazz.newInstance();
                }
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(this.info.clazz)) continue;
                return c.newInstance(root);
            }
        }
        catch (Throwable ex) {
            throw new KettleException("Can't create object " + clazz, ex);
        }
        throw new KettleException("Constructor not found for " + clazz);
    }

    private Object extendArray(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        int existSize;
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            existArray = Array.newInstance(s.leafClass, newSize);
            s.field.set(obj, existArray);
        }
        if ((existSize = Array.getLength(existArray)) < newSize) {
            Object newSized = Array.newInstance(s.leafClass, newSize);
            System.arraycopy(existArray, 0, newSized, 0, existSize);
            existArray = newSized;
            s.field.set(obj, existArray);
        }
        return existArray;
    }

    private List<Object> extendList(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        ArrayList<Object> existList = (ArrayList<Object>)s.field.get(obj);
        if (existList == null) {
            existList = new ArrayList<Object>();
            s.field.set(obj, existList);
        }
        while (existList.size() < newSize) {
            existList.add(null);
        }
        return existList;
    }
}

