/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.BasePainter;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPainterExtension;
import org.pentaho.di.job.entry.JobEntryCopy;

public class JobPainter
extends BasePainter {
    private JobMeta jobMeta;
    private JobHopMeta candidate;
    private List<JobEntryCopy> mouseOverEntries;
    private Map<JobEntryCopy, String> entryLogMap;
    private JobEntryCopy startHopEntry;
    private Point endHopLocation;
    private JobEntryCopy endHopEntry;
    private JobEntryCopy noInputEntry;
    private List<JobEntryCopy> activeJobEntries;
    private List<JobEntryResult> jobEntryResults;

    public JobPainter(GCInterface gc, JobMeta jobMeta, Point area, ScrollBarInterface hori, ScrollBarInterface vert, JobHopMeta candidate, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, List<JobEntryCopy> mouseOverEntries, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight) {
        super(gc, jobMeta, area, hori, vert, drop_candidate, selrect, areaOwners, iconsize, linewidth, gridsize, shadowSize, antiAliasing, noteFontName, noteFontHeight);
        this.jobMeta = jobMeta;
        this.candidate = candidate;
        this.mouseOverEntries = mouseOverEntries;
        this.entryLogMap = null;
    }

    public void drawJob() {
        Point max = this.jobMeta.getMaximum();
        Point thumb = this.getThumb(this.area, max);
        this.offset = this.getOffset(thumb, this.area);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        if (this.hori != null) {
            this.hori.setThumb(thumb.x);
        }
        if (this.vert != null) {
            this.vert.setThumb(thumb.y);
        }
        if (this.shadowSize > 0) {
            this.gc.setAlpha(20);
            this.gc.setTransform(this.translationX, this.translationY, this.shadowSize, this.magnification);
            this.shadow = true;
            this.drawJobElements();
        }
        this.gc.setAlpha(255);
        this.gc.setTransform(this.translationX, this.translationY, 0, this.magnification);
        this.shadow = false;
        this.drawJobElements();
        this.gc.dispose();
    }

    private void drawJobElements() {
        Point end;
        Point start;
        Point to;
        Point fr;
        int i;
        if (!this.shadow && this.gridSize > 1) {
            this.drawGrid();
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobPainterStart.id, (Object)this);
        }
        catch (KettleException e) {
            LogChannel.GENERAL.logError("Error in JobPainterStart extension point", (Throwable)e);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.NOTE);
        for (i = 0; i < this.jobMeta.nrNotes(); ++i) {
            NotePadMeta ni = this.jobMeta.getNote(i);
            this.drawNote(ni);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
        for (i = 0; i < this.jobMeta.nrJobHops(); ++i) {
            JobHopMeta hi = this.jobMeta.getJobHop(i);
            this.drawJobHop(hi, false);
        }
        if (this.candidate != null) {
            this.drawJobHop(this.candidate, true);
        } else if (this.startHopEntry != null && this.endHopLocation != null) {
            PrimitiveGCInterface.EImage arrow;
            fr = this.startHopEntry.getLocation();
            to = this.endHopLocation;
            if (this.endHopEntry == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x + this.iconsize / 2, fr.y + this.iconsize / 2);
            end = this.real2screen(to.x, to.y);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, null, this.startHopEntry, this.endHopEntry == null ? this.endHopLocation : this.endHopEntry);
        } else if (this.endHopEntry != null && this.endHopLocation != null) {
            PrimitiveGCInterface.EImage arrow;
            fr = this.endHopLocation;
            to = this.endHopEntry.getLocation();
            if (this.startHopEntry == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x, fr.y);
            end = this.real2screen(to.x + this.iconsize / 2, to.y + this.iconsize / 2);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y + this.iconsize / 2, this.theta, this.calcArrowLength(), 1.2, null, this.startHopEntry == null ? this.endHopLocation : this.startHopEntry, this.endHopEntry);
        }
        for (int j = 0; j < this.jobMeta.nrJobEntries(); ++j) {
            JobEntryCopy je = this.jobMeta.getJobEntry(j);
            this.drawJobEntryCopy(je);
        }
        if (this.noInputEntry != null) {
            this.gc.setLineWidth(2);
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
            Point n = this.noInputEntry.getLocation();
            this.gc.drawLine(this.offset.x + n.x - 5, this.offset.y + n.y - 5, this.offset.x + n.x + this.iconsize + 5, this.offset.y + n.y + this.iconsize + 5);
            this.gc.drawLine(this.offset.x + n.x - 5, this.offset.y + n.y + this.iconsize + 5, this.offset.x + n.x + this.iconsize + 5, this.offset.y + n.y - 5);
        }
        if (this.drop_candidate != null) {
            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            Point screen = this.real2screen(this.drop_candidate.x, this.drop_candidate.y);
            this.gc.drawRectangle(screen.x, screen.y, this.iconsize, this.iconsize);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobPainterEnd.id, (Object)this);
        }
        catch (KettleException e) {
            LogChannel.GENERAL.logError("Error in JobPainterEnd extension point", (Throwable)e);
        }
        if (!this.shadow) {
            this.drawRect(this.selrect);
        }
    }

    protected void drawJobEntryCopy(JobEntryCopy jobEntryCopy) {
        if (!jobEntryCopy.isDrawn()) {
            return;
        }
        int alpha = this.gc.getAlpha();
        Point pt = jobEntryCopy.getLocation();
        if (pt == null) {
            pt = new Point(50, 50);
        }
        Point screen = this.real2screen(pt.x, pt.y);
        int x = screen.x;
        int y = screen.y;
        String name = jobEntryCopy.getName();
        if (jobEntryCopy.isSelected()) {
            this.gc.setLineWidth(3);
        } else {
            this.gc.setLineWidth(1);
        }
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.fillRoundRectangle(x - 1, y - 1, this.iconsize + 1, this.iconsize + 1, 7, 7);
        this.gc.drawJobEntryIcon(x, y, jobEntryCopy, this.magnification);
        if (!this.shadow) {
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_ICON, x, y, this.iconsize, this.iconsize, this.offset, this.subject, (Object)jobEntryCopy));
        }
        this.gc.setForeground(jobEntryCopy.isMissing() ? PrimitiveGCInterface.EColor.RED : PrimitiveGCInterface.EColor.CRYSTAL);
        this.gc.drawRoundRectangle(x - 1, y - 1, this.iconsize + 1, this.iconsize + 1, 7, 7);
        this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
        Point textsize = new Point(this.gc.textExtent((String)new StringBuilder().append((String)"").append((String)name).toString()).x, this.gc.textExtent((String)new StringBuilder().append((String)"").append((String)name).toString()).y);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.setLineWidth(1);
        int xpos = x + this.iconsize / 2 - textsize.x / 2;
        int ypos = y + this.iconsize + 5;
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.drawText(name, xpos, ypos, true);
        if (this.activeJobEntries != null && this.activeJobEntries.contains(jobEntryCopy)) {
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
            int iconX = x + this.iconsize - 8;
            int iconY = y - 8;
            this.gc.drawImage(PrimitiveGCInterface.EImage.BUSY, iconX, iconY, this.magnification);
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_BUSY, iconX, iconY, 16, 16, this.offset, this.subject, (Object)jobEntryCopy));
        } else {
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        }
        JobEntryResult jobEntryResult = this.findJobEntryResult(jobEntryCopy);
        if (jobEntryResult != null) {
            Result result = jobEntryResult.getResult();
            int iconX = x + this.iconsize - 8;
            int iconY = y - 8;
            if (jobEntryResult.isCheckpoint()) {
                this.gc.drawImage(PrimitiveGCInterface.EImage.CHECKPOINT, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_RESULT_CHECKPOINT, iconX, iconY, 16, 16, this.offset, (Object)jobEntryCopy, (Object)jobEntryResult));
            } else if (result.getResult()) {
                this.gc.drawImage(PrimitiveGCInterface.EImage.TRUE, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_RESULT_SUCCESS, iconX, iconY, 16, 16, this.offset, (Object)jobEntryCopy, (Object)jobEntryResult));
            } else {
                this.gc.drawImage(PrimitiveGCInterface.EImage.FALSE, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_RESULT_FAILURE, iconX, iconY, 16, 16, this.offset, (Object)jobEntryCopy, (Object)jobEntryResult));
            }
        }
        if (this.mouseOverEntries.contains(jobEntryCopy)) {
            this.gc.setTransform(this.translationX, this.translationY, 0, 1.0f);
            PrimitiveGCInterface.EImage[] miniIcons = new PrimitiveGCInterface.EImage[]{PrimitiveGCInterface.EImage.INPUT, PrimitiveGCInterface.EImage.EDIT, PrimitiveGCInterface.EImage.CONTEXT_MENU, PrimitiveGCInterface.EImage.OUTPUT};
            int totalHeight = 0;
            int totalIconsWidth = 0;
            int totalWidth = 10;
            for (PrimitiveGCInterface.EImage miniIcon : miniIcons) {
                Point bounds = this.gc.getImageBounds(miniIcon);
                totalWidth += bounds.x + 5;
                totalIconsWidth += bounds.x + 5;
                if (bounds.y <= totalHeight) continue;
                totalHeight = bounds.y;
            }
            totalHeight += 10;
            this.gc.setFont(PrimitiveGCInterface.EFont.SMALL);
            String trimmedName = jobEntryCopy.getName().length() < 30 ? jobEntryCopy.getName() : jobEntryCopy.getName().substring(0, 30);
            Point nameExtent = this.gc.textExtent(trimmedName);
            nameExtent.y += 10;
            nameExtent.x += 15;
            totalHeight += nameExtent.y;
            if (nameExtent.x > totalWidth) {
                totalWidth = nameExtent.x;
            }
            int areaX = this.translateToCurrentScale(x) + this.translateToCurrentScale(this.iconsize) / 2 - totalWidth / 2 + 0;
            int areaY = this.translateToCurrentScale(y) + this.translateToCurrentScale(this.iconsize) + 4 + 4;
            this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setBackground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setLineWidth(1);
            this.gc.fillRoundRectangle(areaX, areaY, totalWidth, totalHeight, 10, 10);
            this.gc.setBackground(PrimitiveGCInterface.EColor.WHITE);
            this.gc.fillRoundRectangle(areaX, areaY + nameExtent.y, totalWidth, totalHeight - nameExtent.y, 10, 10);
            this.gc.fillRectangle(areaX, areaY + nameExtent.y, totalWidth, (totalHeight - nameExtent.y) / 2);
            this.gc.drawRoundRectangle(areaX, areaY, totalWidth, totalHeight, 10, 10);
            this.gc.setForeground(PrimitiveGCInterface.EColor.WHITE);
            this.gc.drawText(trimmedName, areaX + (totalWidth - nameExtent.x) / 2 + 5, areaY + 5, true);
            this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setBackground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.MINI_ICONS_BALLOON, this.translateTo1To1(areaX), this.translateTo1To1(areaY), this.translateTo1To1(totalWidth), this.translateTo1To1(totalHeight), this.offset, (Object)this.jobMeta, (Object)jobEntryCopy));
            this.gc.fillPolygon(new int[]{areaX + totalWidth / 2 - 10 + 1, areaY + 2, areaX + totalWidth / 2 + 10, areaY + 2, areaX + totalWidth / 2 - 0, areaY - 4 - 3});
            this.gc.setBackground(PrimitiveGCInterface.EColor.WHITE);
            int xIcon = areaX + (totalWidth - totalIconsWidth) / 2 + 5;
            int yIcon = areaY + 5 + nameExtent.y;
            for (int i = 0; i < miniIcons.length; ++i) {
                PrimitiveGCInterface.EImage miniIcon = miniIcons[i];
                Point bounds = this.gc.getImageBounds(miniIcon);
                boolean enabled = false;
                switch (i) {
                    case 0: {
                        enabled = !jobEntryCopy.isStart();
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_MINI_ICON_INPUT, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)this.jobMeta, (Object)jobEntryCopy));
                        break;
                    }
                    case 1: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_MINI_ICON_EDIT, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)this.jobMeta, (Object)jobEntryCopy));
                        break;
                    }
                    case 2: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_MINI_ICON_CONTEXT, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)this.jobMeta, (Object)jobEntryCopy));
                        break;
                    }
                    case 3: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_ENTRY_MINI_ICON_OUTPUT, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)this.jobMeta, (Object)jobEntryCopy));
                        break;
                    }
                }
                if (enabled) {
                    this.gc.setAlpha(255);
                } else {
                    this.gc.setAlpha(100);
                }
                this.gc.drawImage(miniIcon, xIcon, yIcon, 1.0f);
                xIcon += bounds.x + 5;
            }
            this.gc.setTransform(this.translationX, this.translationY, 0, this.magnification);
        }
        this.gc.setAlpha(alpha);
    }

    private JobEntryResult findJobEntryResult(JobEntryCopy jobEntryCopy) {
        if (this.jobEntryResults == null) {
            return null;
        }
        for (JobEntryResult jobEntryResult : this.jobEntryResults) {
            if (!jobEntryResult.getJobEntryName().equals(jobEntryCopy.getName()) || jobEntryResult.getJobEntryNr() != jobEntryCopy.getNr()) continue;
            return jobEntryResult;
        }
        return null;
    }

    protected void drawJobHop(JobHopMeta hop, boolean candidate) {
        if (hop == null || hop.getFromEntry() == null || hop.getToEntry() == null) {
            return;
        }
        if (!hop.getFromEntry().isDrawn() || !hop.getToEntry().isDrawn()) {
            return;
        }
        this.drawLine(hop, candidate);
    }

    protected void drawLine(JobHopMeta jobHop, boolean is_candidate) {
        PrimitiveGCInterface.EImage arrow;
        PrimitiveGCInterface.EColor col;
        int[] line = this.getLine(jobHop.getFromEntry(), jobHop.getToEntry());
        this.gc.setLineWidth(this.linewidth);
        if (jobHop.getFromEntry().isLaunchingInParallel()) {
            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.PARALLEL);
        } else {
            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
        }
        if (is_candidate) {
            col = PrimitiveGCInterface.EColor.BLUE;
            arrow = PrimitiveGCInterface.EImage.ARROW_CANDIDATE;
        } else if (jobHop.isEnabled()) {
            if (jobHop.isUnconditional()) {
                col = PrimitiveGCInterface.EColor.HOP_DEFAULT;
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            } else if (jobHop.getEvaluation()) {
                col = PrimitiveGCInterface.EColor.HOP_OK;
                arrow = PrimitiveGCInterface.EImage.ARROW_OK;
            } else {
                col = PrimitiveGCInterface.EColor.RED;
                arrow = PrimitiveGCInterface.EImage.ARROW_ERROR;
                this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DASH);
            }
        } else {
            col = PrimitiveGCInterface.EColor.GRAY;
            arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
        }
        this.gc.setForeground(col);
        if (jobHop.isSplit()) {
            this.gc.setLineWidth(this.linewidth + 2);
        }
        this.drawArrow(arrow, line, jobHop);
        if (jobHop.isSplit()) {
            this.gc.setLineWidth(this.linewidth);
        }
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
    }

    protected int[] getLine(JobEntryCopy fs, JobEntryCopy ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconsize / 2;
        int y1 = from.y + this.iconsize / 2;
        int x2 = to.x + this.iconsize / 2;
        int y2 = to.y + this.iconsize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    private void drawArrow(PrimitiveGCInterface.EImage arrow, int[] line, JobHopMeta jobHop) {
        this.drawArrow(arrow, line, jobHop, jobHop.getFromEntry(), jobHop.getToEntry());
    }

    private void drawArrow(PrimitiveGCInterface.EImage arrow, int[] line, JobHopMeta jobHop, Object startObject, Object endObject) {
        Point screen_from = this.real2screen(line[0], line[1]);
        Point screen_to = this.real2screen(line[2], line[3]);
        this.drawArrow(arrow, screen_from.x, screen_from.y, screen_to.x, screen_to.y, this.theta, this.calcArrowLength(), -1.0, jobHop, startObject, endObject);
    }

    private void drawArrow(PrimitiveGCInterface.EImage arrow, int x1, int y1, int x2, int y2, double theta, int size, double factor, JobHopMeta jobHop, Object startObject, Object endObject) {
        boolean q4;
        this.gc.drawLine(x1, y1, x2, y2);
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        if (factor < 0.0) {
            factor = dist >= 2 * this.iconsize ? 1.3 : 1.2;
        }
        int mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        int my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + 1.5707963267948966;
        boolean q1 = Math.toDegrees(angle) >= 0.0 && Math.toDegrees(angle) <= 90.0;
        boolean q2 = Math.toDegrees(angle) > 90.0 && Math.toDegrees(angle) <= 180.0;
        boolean q3 = Math.toDegrees(angle) > 180.0 && Math.toDegrees(angle) <= 270.0;
        boolean bl = q4 = Math.toDegrees(angle) > 270.0 || Math.toDegrees(angle) < 0.0;
        if (q1 || q3) {
            this.gc.drawImage(arrow, mx + 1, my, this.magnification, angle);
        } else if (q2 || q4) {
            this.gc.drawImage(arrow, mx, my, this.magnification, angle);
        }
        factor = 0.8;
        mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - 8;
        my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - 8;
        if (jobHop != null) {
            PrimitiveGCInterface.EImage hopsIcon = jobHop.isUnconditional() ? PrimitiveGCInterface.EImage.UNCONDITIONAL : (jobHop.getEvaluation() ? PrimitiveGCInterface.EImage.TRUE : PrimitiveGCInterface.EImage.FALSE);
            Point bounds = this.gc.getImageBounds(hopsIcon);
            this.gc.drawImage(hopsIcon, mx, my, this.magnification);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_HOP_ICON, mx, my, bounds.x, bounds.y, this.offset, this.subject, (Object)jobHop));
            }
            if (jobHop.getFromEntry().isLaunchingInParallel()) {
                factor = 1.0;
                mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - 8;
                my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - 8;
                hopsIcon = PrimitiveGCInterface.EImage.PARALLEL;
                this.gc.drawImage(hopsIcon, mx, my, this.magnification);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.JOB_HOP_PARALLEL_ICON, mx, my, bounds.x, bounds.y, this.offset, this.subject, (Object)jobHop));
                }
            }
            JobPainterExtension extension = new JobPainterExtension(this.gc, this.shadow, this.areaOwners, this.jobMeta, jobHop, x1, y1, x2, y2, mx, my, this.offset);
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobPainterArrow.id, (Object)extension);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error calling extension point(s) for the job painter arrow", (Throwable)e);
            }
        }
    }

    public List<JobEntryCopy> getMouseOverEntries() {
        return this.mouseOverEntries;
    }

    public void setMouseOverEntries(List<JobEntryCopy> mouseOverEntries) {
        this.mouseOverEntries = mouseOverEntries;
    }

    public Map<JobEntryCopy, String> getEntryLogMap() {
        return this.entryLogMap;
    }

    public void setEntryLogMap(Map<JobEntryCopy, String> entryLogMap) {
        this.entryLogMap = entryLogMap;
    }

    public void setStartHopEntry(JobEntryCopy startHopEntry) {
        this.startHopEntry = startHopEntry;
    }

    public void setEndHopLocation(Point endHopLocation) {
        this.endHopLocation = endHopLocation;
    }

    public void setEndHopEntry(JobEntryCopy endHopEntry) {
        this.endHopEntry = endHopEntry;
    }

    public void setNoInputEntry(JobEntryCopy noInputEntry) {
        this.noInputEntry = noInputEntry;
    }

    public void setActiveJobEntries(List<JobEntryCopy> activeJobEntries) {
        this.activeJobEntries = activeJobEntries;
    }

    public List<JobEntryResult> getJobEntryResults() {
        return this.jobEntryResults;
    }

    public void setJobEntryResults(List<JobEntryResult> jobEntryResults) {
        this.jobEntryResults = jobEntryResults;
        Collections.sort(this.jobEntryResults);
    }

    @Override
    public float getTranslationX() {
        return this.translationX;
    }

    @Override
    public void setTranslationX(float translationX) {
        this.translationX = translationX;
    }

    @Override
    public float getTranslationY() {
        return this.translationY;
    }

    @Override
    public void setTranslationY(float translationY) {
        this.translationY = translationY;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public JobHopMeta getCandidate() {
        return this.candidate;
    }

    public void setCandidate(JobHopMeta candidate) {
        this.candidate = candidate;
    }

    public JobEntryCopy getStartHopEntry() {
        return this.startHopEntry;
    }

    public Point getEndHopLocation() {
        return this.endHopLocation;
    }

    public JobEntryCopy getEndHopEntry() {
        return this.endHopEntry;
    }

    public JobEntryCopy getNoInputEntry() {
        return this.noInputEntry;
    }

    public List<JobEntryCopy> getActiveJobEntries() {
        return this.activeJobEntries;
    }
}

