/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappingoutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputData;
import org.pentaho.metastore.api.IMetaStore;

public class MappingOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MappingOutputMeta.class;
    private volatile List<MappingValueRename> inputValueRenames = new ArrayList<MappingValueRename>();
    private volatile List<MappingValueRename> outputValueRenames;

    @Override
    public Object clone() {
        MappingOutputMeta retval = (MappingOutputMeta)super.clone();
        return retval;
    }

    public void allocate(int nrfields) {
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInterface valueMeta;
        if (this.inputValueRenames != null) {
            for (MappingValueRename valueRename : this.inputValueRenames) {
                valueMeta = r.searchValueMeta(valueRename.getTargetValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(valueRename.getSourceValueName());
            }
        }
        if (this.outputValueRenames != null) {
            for (MappingValueRename valueRename : this.outputValueRenames) {
                valueMeta = r.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(valueRename.getTargetValueName());
            }
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MappingOutputMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingOutputMeta.CheckResult.StepReceivingDatasOK", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingOutputMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingOutputMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MappingOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MappingOutputData();
    }

    public List<MappingValueRename> getInputValueRenames() {
        return this.inputValueRenames;
    }

    public void setInputValueRenames(List<MappingValueRename> inputValueRenames) {
        this.inputValueRenames = inputValueRenames;
    }

    public List<MappingValueRename> getOutputValueRenames() {
        return this.outputValueRenames;
    }

    public void setOutputValueRenames(List<MappingValueRename> outputValueRenames) {
        this.outputValueRenames = outputValueRenames;
    }
}

