/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.NormaliserData;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class Normaliser
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = NormaliserMeta.class;
    private NormaliserMeta meta;
    private NormaliserData data;

    public Normaliser(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.type_occ = new ArrayList<String>();
            this.data.maxlen = 0;
            for (i = 0; i < this.meta.getNormaliserFields().length; ++i) {
                if (!this.data.type_occ.contains(this.meta.getNormaliserFields()[i].getValue())) {
                    this.data.type_occ.add(this.meta.getNormaliserFields()[i].getValue());
                }
                if (this.meta.getNormaliserFields()[i].getValue().length() <= this.data.maxlen) continue;
                this.data.maxlen = this.meta.getNormaliserFields()[i].getValue().length();
            }
            this.data.copy_fieldnrs = new ArrayList<Integer>();
            for (i = 0; i < this.data.inputRowMeta.size(); ++i) {
                ValueMetaInterface v = this.data.inputRowMeta.getValueMeta(i);
                if (Const.indexOfString((String)v.getName(), (String[])this.meta.getFieldNames()) >= 0) continue;
                this.data.copy_fieldnrs.add(i);
            }
            this.data.fieldnrs = new int[this.meta.getNormaliserFields().length];
            for (i = 0; i < this.meta.getNormaliserFields().length; ++i) {
                this.data.fieldnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getNormaliserFields()[i].getName());
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"Normaliser.Log.CouldNotFindFieldInRow", (String[])new String[]{this.meta.getNormaliserFields()[i].getName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        for (int e = 0; e < this.data.type_occ.size(); ++e) {
            int i;
            String typevalue = this.data.type_occ.get(e);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            for (i = 0; i < this.data.copy_fieldnrs.size(); ++i) {
                int nr = this.data.copy_fieldnrs.get(i);
                outputRowData[outputIndex++] = r[nr];
            }
            outputRowData[outputIndex++] = typevalue;
            for (i = 0; i < this.data.fieldnrs.length; ++i) {
                Object value = r[this.data.fieldnrs[i]];
                String fieldValue = this.meta.getNormaliserFields()[i].getValue();
                if (!fieldValue.equalsIgnoreCase(typevalue)) continue;
                outputRowData[outputIndex++] = value;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Normaliser.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        return super.init(smi, sdi);
    }
}

