/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class RemoveTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = RemoveTransServlet.class;
    private static final long serialVersionUID = 6618979989596401783L;
    public static final String CONTEXT_PATH = "/kettle/removeTrans";

    public RemoveTransServlet() {
    }

    public RemoveTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trans trans;
        CarteObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.RemoveTransRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
            if (entry == null) {
                trans = null;
            } else {
                id = entry.getId();
                trans = this.getTransformationMap().getTransformation(entry);
            }
        } else {
            entry = new CarteObjectEntry(transName, id);
            trans = this.getTransformationMap().getTransformation(entry);
        }
        Encoder encoder = ESAPI.encoder();
        if (trans != null) {
            KettleLogStore.discardLines((String)trans.getLogChannelId(), (boolean)true);
            this.getTransformationMap().removeTransformation(entry);
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                out.print(WebResult.OK.getXML());
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"RemoveTransServlet.TransRemoved", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<H3>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"RemoveTransServlet.TheTransWasRemoved", (String[])new String[]{transName, id})) + "</H3>");
                out.print("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.println("<p>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})));
        } else {
            out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"RemoveTransServlet.TransRemoved.Log.CoundNotFindTrans", (String[])new String[]{transName, id})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Remove transformation servlet";
    }

    @Override
    public String getService() {
        return "/kettle/removeTrans (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

