/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class StartExecutionTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = StartExecutionTransServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/startExec";

    public StartExecutionTransServlet() {
    }

    public StartExecutionTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Start execution of transformation requested");
        }
        response.setStatus(200);
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        Encoder encoder = ESAPI.encoder();
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.TransPrepareExecution", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/status") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            Trans trans;
            if (Utils.isEmpty((CharSequence)id)) {
                CarteObjectEntry entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
                if (entry == null) {
                    trans = null;
                } else {
                    id = entry.getId();
                    trans = this.getTransformationMap().getTransformation(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(transName, id);
                trans = this.getTransformationMap().getTransformation(entry);
            }
            if (trans != null) {
                if (trans.isReadyToStart()) {
                    this.startThreads(trans);
                    if (useXML) {
                        out.println(WebResult.OK.getXML());
                    } else {
                        out.println("<H1>Transformation '" + encoder.encodeForHTML(transName) + "' has been executed.</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">Back to the transformation status page</a><p>");
                    }
                } else {
                    String message = "The specified transformation [" + transName + "] is not ready to be started. (Was not prepared for execution)";
                    if (useXML) {
                        out.println(new WebResult("ERROR", message));
                    } else {
                        out.println("<H1>" + encoder.encodeForHTML(message) + "</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    }
                }
            } else if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})));
            } else {
                out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindTrans", (String[])new String[]{transName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", "Unexpected error during transformation execution preparation:" + Const.CR + Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(encoder.encodeForHTML(Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start transformation";
    }

    @Override
    public String getService() {
        return "/kettle/startExec (" + this.toString() + ")";
    }

    protected void startThreads(Trans trans) throws KettleException {
        trans.startThreads();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

