/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemCallable;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemImpl;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemFactoryImpl
implements HadoopFileSystemFactory {
    public static final String SHIM_IDENTIFIER = "shim.identifier";
    public static final String HDFS = "hdfs";
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemFactoryImpl.class);
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;

    public HadoopFileSystemFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        Object shimIdentifier = null;
        return shimIdentifier == null && this.isActiveConfiguration || this.hadoopConfiguration.getIdentifier().equals(shimIdentifier);
    }

    public HadoopFileSystem create(NamedCluster namedCluster) throws IOException {
        String fsDefault;
        final HadoopShim hadoopShim = this.hadoopConfiguration.getHadoopShim();
        final Configuration configuration = hadoopShim.createConfiguration();
        if (namedCluster.isMapr()) {
            fsDefault = "maprfs:///";
        } else {
            Variables variables = new Variables();
            variables.initializeVariablesFrom(null);
            fsDefault = "hdfs://" + variables.environmentSubstitute(namedCluster.getHdfsHost());
            String port = variables.environmentSubstitute(namedCluster.getHdfsPort());
            if (!Const.isEmpty((String)port)) {
                fsDefault = fsDefault + ":" + port;
            }
        }
        configuration.set("fs.default.name", fsDefault);
        FileSystem fileSystem = (FileSystem)hadoopShim.getFileSystem(configuration).getDelegate();
        if (fileSystem instanceof LocalFileSystem) {
            throw new IOException("Got a local filesystem, was expecting an hdfs connection");
        }
        return new HadoopFileSystemImpl(new HadoopFileSystemCallable(){

            @Override
            public FileSystem getFileSystem() {
                try {
                    return (FileSystem)hadoopShim.getFileSystem(configuration).getDelegate();
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }
}

