/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.MondrianSchemaAnnotator;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.solution.filebased.MondrianFileObject;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryVfsFileObject;

public class MondrianVfs
implements FileProvider {
    public static final String SCHEMA_XML = "schema.xml";
    public static final String ANNOTATIONS_XML = "annotations.xml";
    public static final String ANNOTATOR_KEY = "inlineModeling";

    public FileObject createFileSystem(String arg0, FileObject arg1, FileSystemOptions arg2) throws FileSystemException {
        return null;
    }

    public FileObject findFile(FileObject arg0, String catalog, FileSystemOptions arg2) throws FileSystemException {
        catalog = catalog.substring(catalog.indexOf(":") + 1);
        FileObject schemaFile = this.getCatalogFileObject(catalog, SCHEMA_XML);
        FileObject annotationsFile = this.getCatalogFileObject(catalog, ANNOTATIONS_XML);
        MondrianSchemaAnnotator annotator = this.getAnnotator();
        if (annotationsFile.exists() && annotator != null) {
            return new MondrianFileObject(schemaFile, annotationsFile, annotator);
        }
        return schemaFile;
    }

    MondrianSchemaAnnotator getAnnotator() {
        return (MondrianSchemaAnnotator)PentahoSystem.get(MondrianSchemaAnnotator.class, (String)ANNOTATOR_KEY, (IPentahoSession)PentahoSessionHolder.getSession());
    }

    FileObject getCatalogFileObject(String catalog, String fileName) {
        return new SolutionRepositoryVfsFileObject("/etc/mondrian" + catalog + "/" + fileName);
    }

    public Collection getCapabilities() {
        return null;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    public FileName parseUri(FileName arg0, String arg1) throws FileSystemException {
        return null;
    }
}

