/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.util.LocalizationUtil;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataDomainRepository;
import org.pentaho.platform.repository2.unified.RepositoryUtils;

public class CachingPentahoMetadataDomainRepository
extends PentahoMetadataDomainRepository {
    private Map<String, Domain> cache = new HashMap<String, Domain>();

    public CachingPentahoMetadataDomainRepository(IUnifiedRepository repository) {
        super(repository);
    }

    public CachingPentahoMetadataDomainRepository(IUnifiedRepository repository, RepositoryUtils repositoryUtils, XmiParser xmiParser, LocalizationUtil localizationUtil) {
        super(repository, repositoryUtils, xmiParser, localizationUtil);
    }

    @Override
    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        super.storeDomain(domain, overwrite);
        this.cache.put(domain.getId(), domain);
    }

    @Override
    public Domain getDomain(String domainId) {
        Domain domain = this.cache.get(domainId);
        if (null == domain && null != (domain = super.getDomain(domainId))) {
            this.cache.put(domainId, domain);
        }
        return domain;
    }

    @Override
    public Set<String> getDomainIds() {
        if (this.cache.isEmpty()) {
            Set<String> domainIds = super.getDomainIds();
            for (String domainId : domainIds) {
                this.cache.put(domainId, null);
            }
        }
        return this.cache.keySet();
    }

    @Override
    public void reloadDomains() {
        this.flushDomains();
    }

    @Override
    public void flushDomains() {
        super.flushDomains();
        this.cache.clear();
    }
}

