/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DateTimeConverter {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private AS400 system_;
    private ProgramCall program_;
    private AS400Text text10_;
    private Calendar calendar_ = Calendar.getInstance();
    private DateTime17Format format17_;
    private DateTime16Format format16_;

    public DateTimeConverter(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.program_ = new ProgramCall(this.system_);
        this.text10_ = new AS400Text(10, this.system_.getCcsid(), this.system_);
        this.format17_ = new DateTime17Format(this.system_);
        this.format16_ = new DateTime16Format(this.system_);
    }

    public byte[] convert(byte[] byArray, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (string == null) {
            throw new NullPointerException("inFormat");
        }
        if (string2 == null) {
            throw new NullPointerException("outFormat");
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(this.text10_.toBytes(string));
        programParameterArray[1] = new ProgramParameter(byArray);
        programParameterArray[2] = new ProgramParameter(this.text10_.toBytes(string2));
        programParameterArray[3] = new ProgramParameter(17);
        byte[] byArray2 = new byte[70];
        programParameterArray[4] = new ProgramParameter(byArray2);
        try {
            this.program_.setProgram("/QSYS.LIB/QWCCVTDT.PGM", programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.program_.setThreadSafe(true);
        if (!this.program_.run()) {
            Trace.log(2, "DateTimeConverter call to QWCCVTDT failed.");
            AS400Message[] aS400MessageArray = this.program_.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                Trace.log(2, aS400MessageArray[i].toString());
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray3 = programParameterArray[3].getOutputData();
        return byArray3;
    }

    public Date convert(byte[] byArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (string == null) {
            throw new NullPointerException("inFormat");
        }
        byte[] byArray2 = this.convert(byArray, string, "*YYMD");
        this.calendar_.clear();
        Record record = this.format17_.getNewRecord(byArray2);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "DateTimeConverter record parsed from bytes: " + record.toString());
        }
        this.calendar_.set(Integer.parseInt(((String)record.getField("year")).trim()), Integer.parseInt(((String)record.getField("month")).trim()) - 1, Integer.parseInt(((String)record.getField("day")).trim()), Integer.parseInt(((String)record.getField("hour")).trim()), Integer.parseInt(((String)record.getField("minute")).trim()), Integer.parseInt(((String)record.getField("second")).trim()));
        this.calendar_.set(14, Integer.parseInt(((String)record.getField("millisecond")).trim()));
        return this.calendar_.getTime();
    }

    public byte[] convert(Date date, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (string == null) {
            throw new NullPointerException("outFormat");
        }
        this.calendar_.clear();
        this.calendar_.setTime(date);
        Record record = this.format17_.getNewRecord();
        record.setField("year", (Object)Integer.toString(this.calendar_.get(1)));
        int n = this.calendar_.get(2) + 1;
        String string2 = (n < 10 ? "0" : "") + n;
        record.setField("month", (Object)string2);
        int n2 = this.calendar_.get(5);
        String string3 = (n2 < 10 ? "0" : "") + n2;
        record.setField("day", (Object)string3);
        int n3 = this.calendar_.get(11);
        String string4 = (n3 < 10 ? "0" : "") + n3;
        record.setField("hour", (Object)string4);
        int n4 = this.calendar_.get(12);
        String string5 = (n4 < 10 ? "0" : "") + n4;
        record.setField("minute", (Object)string5);
        int n5 = this.calendar_.get(13);
        String string6 = (n5 < 10 ? "0" : "") + n5;
        record.setField("second", (Object)string6);
        int n6 = this.calendar_.get(14);
        String string7 = (n6 < 100 ? "0" : "") + (n6 < 10 ? "0" : "") + n6;
        record.setField("millisecond", (Object)string7);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "DateTimeConverter record parsed from Date: " + record.toString());
        }
        byte[] byArray = record.getContents();
        return this.convert(byArray, "*YYMD", string);
    }

    private class DateTime16Format
    extends RecordFormat {
        DateTime16Format(AS400 aS400) {
            int n = aS400.getCcsid();
            AS400Text aS400Text = new AS400Text(2, n, aS400);
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(1, n, aS400), "century"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "year"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "month"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "day"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "hour"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "minute"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "second"));
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(3, n, aS400), "millisecond"));
        }
    }

    private class DateTime17Format
    extends RecordFormat {
        DateTime17Format(AS400 aS400) {
            int n = aS400.getCcsid();
            AS400Text aS400Text = new AS400Text(2, n, aS400);
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(4, n, aS400), "year"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "month"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "day"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "hour"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "minute"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "second"));
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(3, n, aS400), "millisecond"));
        }
    }
}

