/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.aries.rsa.provider.fastbin.api.Dispatched;
import org.apache.aries.rsa.provider.fastbin.api.ObjectSerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.api.Serialization;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.io.ServerInvoker;
import org.apache.aries.rsa.provider.fastbin.io.Transport;
import org.apache.aries.rsa.provider.fastbin.io.TransportAcceptListener;
import org.apache.aries.rsa.provider.fastbin.io.TransportListener;
import org.apache.aries.rsa.provider.fastbin.io.TransportServer;
import org.apache.aries.rsa.provider.fastbin.streams.StreamProvider;
import org.apache.aries.rsa.provider.fastbin.streams.StreamProviderImpl;
import org.apache.aries.rsa.provider.fastbin.tcp.BlockingInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationType;
import org.apache.aries.rsa.provider.fastbin.tcp.LengthPrefixedCodec;
import org.apache.aries.rsa.provider.fastbin.tcp.TcpTransport;
import org.apache.aries.rsa.provider.fastbin.tcp.TcpTransportFactory;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInvokerImpl
implements ServerInvoker,
Dispatched {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ServerInvokerImpl.class);
    private static final HashMap<String, Class> PRIMITIVE_TO_CLASS = new HashMap(8, 1.0f);
    protected final ExecutorService blockingExecutor = Executors.newFixedThreadPool(8);
    protected final DispatchQueue queue;
    private final Map<String, SerializationStrategy> serializationStrategies;
    protected final TransportServer server;
    protected final Map<UTF8Buffer, ServiceFactoryHolder> holders = new HashMap<UTF8Buffer, ServiceFactoryHolder>();
    private StreamProvider streamProvider;

    public ServerInvokerImpl(String address, DispatchQueue queue, Map<String, SerializationStrategy> serializationStrategies) throws Exception {
        this.queue = queue;
        this.serializationStrategies = serializationStrategies;
        this.server = new TcpTransportFactory().bind(address);
        this.server.setDispatchQueue(queue);
        this.server.setAcceptListener(new InvokerAcceptListener());
    }

    public InetSocketAddress getSocketAddress() {
        return this.server.getSocketAddress();
    }

    @Override
    public DispatchQueue queue() {
        return this.queue;
    }

    @Override
    public String getConnectAddress() {
        return this.server.getConnectAddress();
    }

    @Override
    public StreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    @Override
    public void registerService(final String id, final ServerInvoker.ServiceFactory service, final ClassLoader classLoader) {
        this.queue().execute(new Runnable(){

            @Override
            public void run() {
                ServerInvokerImpl.this.holders.put(new UTF8Buffer(id), new ServiceFactoryHolder(service, classLoader));
            }
        });
    }

    @Override
    public void unregisterService(final String id) {
        this.queue().execute(new Runnable(){

            @Override
            public void run() {
                ServerInvokerImpl.this.holders.remove(new UTF8Buffer(id));
            }
        });
    }

    @Override
    public void start() throws Exception {
        this.start(null);
    }

    @Override
    public void start(Runnable onComplete) throws Exception {
        this.registerStreamProvider();
        this.server.start(onComplete);
    }

    private void registerStreamProvider() {
        this.streamProvider = new StreamProviderImpl();
        this.registerService("stream-provider", new ServerInvoker.ServiceFactory(){

            @Override
            public Object get() {
                return ServerInvokerImpl.this.streamProvider;
            }

            @Override
            public void unget() {
            }
        }, this.getClass().getClassLoader());
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Runnable onComplete) {
        this.server.stop(new Runnable(){

            @Override
            public void run() {
                ServerInvokerImpl.this.blockingExecutor.shutdown();
                if (onComplete != null) {
                    onComplete.run();
                }
            }
        });
    }

    protected void onCommand(final Transport transport, Object data) {
        try {
            Object svc;
            final DataByteArrayInputStream bais = new DataByteArrayInputStream((Buffer)data);
            int size = bais.readInt();
            final long correlation = bais.readVarLong();
            final UTF8Buffer service = this.readBuffer(bais).utf8();
            Buffer encoded_method = this.readBuffer(bais);
            final ServiceFactoryHolder holder = this.holders.get(service);
            Runnable task = null;
            if (holder == null) {
                LOGGER.warn("The requested service {" + service + "} is not available");
                task = new Runnable(){

                    @Override
                    public void run() {
                        final DataByteArrayOutputStream baos = new DataByteArrayOutputStream();
                        try {
                            baos.writeInt(0);
                            baos.writeVarLong(correlation);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to write to buffer", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        BlockingInvocationStrategy strategy = new BlockingInvocationStrategy();
                        strategy.service(ObjectSerializationStrategy.INSTANCE, this.getClass().getClassLoader(), null, new ServiceException("The requested service {" + service + "} is not available"), bais, baos, new Runnable(){

                            @Override
                            public void run() {
                                final Buffer command = baos.toBuffer();
                                BufferEditor editor = command.buffer().bigEndianEditor();
                                editor.writeInt(command.length);
                                ServerInvokerImpl.this.queue().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        transport.offer(command);
                                    }
                                });
                            }
                        });
                    }
                };
            }
            Object object = svc = holder == null ? null : holder.factory.get();
            if (holder != null) {
                final MethodData methodData = holder.getMethodData(encoded_method);
                task = new Runnable(){

                    @Override
                    public void run() {
                        final DataByteArrayOutputStream baos = new DataByteArrayOutputStream();
                        try {
                            baos.writeInt(0);
                            baos.writeVarLong(correlation);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to write to buffer", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        methodData.invocationStrategy.service(methodData.serializationStrategy, holder.loader, methodData.method, svc, bais, baos, new Runnable(){

                            @Override
                            public void run() {
                                holder.factory.unget();
                                final Buffer command = baos.toBuffer();
                                BufferEditor editor = command.buffer().bigEndianEditor();
                                editor.writeInt(command.length);
                                ServerInvokerImpl.this.queue().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        transport.offer(command);
                                    }
                                });
                            }
                        });
                    }
                };
            }
            ExecutorService executor = svc instanceof Dispatched ? ((Dispatched)svc).queue() : this.blockingExecutor;
            executor.execute(task);
        }
        catch (Exception e) {
            LOGGER.info("Error while reading request", (Throwable)e);
        }
    }

    private Buffer readBuffer(DataByteArrayInputStream bais) throws IOException {
        byte[] b = new byte[bais.readVarInt()];
        bais.readFully(b);
        return new Buffer(b);
    }

    static {
        PRIMITIVE_TO_CLASS.put("Z", Boolean.TYPE);
        PRIMITIVE_TO_CLASS.put("B", Byte.TYPE);
        PRIMITIVE_TO_CLASS.put("C", Character.TYPE);
        PRIMITIVE_TO_CLASS.put("S", Short.TYPE);
        PRIMITIVE_TO_CLASS.put("I", Integer.TYPE);
        PRIMITIVE_TO_CLASS.put("J", Long.TYPE);
        PRIMITIVE_TO_CLASS.put("F", Float.TYPE);
        PRIMITIVE_TO_CLASS.put("D", Double.TYPE);
    }

    class InvokerTransportListener
    implements TransportListener {
        InvokerTransportListener() {
        }

        @Override
        public void onTransportCommand(Transport transport, Object command) {
            ServerInvokerImpl.this.onCommand(transport, command);
        }

        @Override
        public void onRefill(Transport transport) {
        }

        @Override
        public void onTransportFailure(Transport transport, IOException error) {
            if (!transport.isDisposed() && !(error instanceof EOFException)) {
                LOGGER.info("Transport failure", (Throwable)error);
            }
        }

        @Override
        public void onTransportConnected(Transport transport) {
            transport.resumeRead();
        }

        @Override
        public void onTransportDisconnected(Transport transport) {
        }
    }

    class InvokerAcceptListener
    implements TransportAcceptListener {
        InvokerAcceptListener() {
        }

        @Override
        public void onAccept(TransportServer transportServer, TcpTransport transport) {
            transport.setProtocolCodec(new LengthPrefixedCodec());
            transport.setDispatchQueue(ServerInvokerImpl.this.queue());
            transport.setTransportListener(new InvokerTransportListener());
            transport.start();
        }

        @Override
        public void onAcceptError(TransportServer transportServer, Exception error) {
            LOGGER.info("Error accepting incoming connection", (Throwable)error);
        }
    }

    class ServiceFactoryHolder {
        private final ServerInvoker.ServiceFactory factory;
        private final ClassLoader loader;
        private final Class clazz;
        private HashMap<Buffer, MethodData> method_cache = new HashMap();

        public ServiceFactoryHolder(ServerInvoker.ServiceFactory factory, ClassLoader loader) {
            this.factory = factory;
            this.loader = loader;
            Object o = factory.get();
            this.clazz = o.getClass();
            factory.unget();
        }

        private MethodData getMethodData(Buffer data) throws IOException, NoSuchMethodException, ClassNotFoundException {
            MethodData rc = this.method_cache.get(data);
            if (rc == null) {
                SerializationStrategy serializationStrategy;
                String[] parts = data.utf8().toString().split(",");
                String name = parts[0];
                Class[] params = new Class[parts.length - 1];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = this.decodeClass(parts[i + 1]);
                }
                Method method = this.clazz.getMethod(name, params);
                Serialization annotation = method.getAnnotation(Serialization.class);
                if (annotation != null) {
                    serializationStrategy = (SerializationStrategy)ServerInvokerImpl.this.serializationStrategies.get(annotation.value());
                    if (serializationStrategy == null) {
                        throw new RuntimeException("Could not find the serialization strategy named: " + annotation.value());
                    }
                } else {
                    serializationStrategy = ObjectSerializationStrategy.INSTANCE;
                }
                InvocationStrategy invocationStrategy = InvocationType.forMethod(method);
                rc = new MethodData(invocationStrategy, serializationStrategy, method);
                this.method_cache.put(data, rc);
            }
            return rc;
        }

        private Class<?> decodeClass(String s) throws ClassNotFoundException {
            if (s.startsWith("[")) {
                Class<?> nested = this.decodeClass(s.substring(1));
                return Array.newInstance(nested, 0).getClass();
            }
            String c = s.substring(0, 1);
            if (c.equals("L")) {
                return this.loader.loadClass(s.substring(1));
            }
            return (Class)PRIMITIVE_TO_CLASS.get(c);
        }
    }

    static class MethodData {
        private final SerializationStrategy serializationStrategy;
        final InvocationStrategy invocationStrategy;
        final Method method;

        MethodData(InvocationStrategy invocationStrategy, SerializationStrategy serializationStrategy, Method method) {
            this.invocationStrategy = invocationStrategy;
            this.serializationStrategy = serializationStrategy;
            this.method = method;
        }
    }
}

