/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.backup.BackupCopyService;
import org.apache.hadoop.hbase.backup.IncrementalRestoreService;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceBackupCopyService;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceRestoreService;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupRestoreServerFactory {
    public static final String HBASE_INCR_RESTORE_IMPL_CLASS = "hbase.incremental.restore.class";
    public static final String HBASE_BACKUP_COPY_IMPL_CLASS = "hbase.backup.copy.class";

    private BackupRestoreServerFactory() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static IncrementalRestoreService getIncrementalRestoreService(Configuration conf) {
        Class cls = conf.getClass(HBASE_INCR_RESTORE_IMPL_CLASS, MapReduceRestoreService.class, IncrementalRestoreService.class);
        IncrementalRestoreService service = (IncrementalRestoreService)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        service.setConf(conf);
        return service;
    }

    public static BackupCopyService getBackupCopyService(Configuration conf) {
        Class cls = conf.getClass(HBASE_BACKUP_COPY_IMPL_CLASS, MapReduceBackupCopyService.class, BackupCopyService.class);
        BackupCopyService service = (BackupCopyService)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        service.setConf(conf);
        return service;
    }
}

