/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.IncrementalRestoreService;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MapReduceRestoreService
implements IncrementalRestoreService {
    public static final Log LOG = LogFactory.getLog(MapReduceRestoreService.class);
    private WALPlayer player = new WALPlayer();

    @Override
    public void run(Path[] logDirPaths, TableName[] tableNames, TableName[] newTableNames) throws IOException {
        String logDirs = StringUtils.join((Object[])logDirPaths, (String)",");
        LOG.info((Object)("Restore incremental backup from directory " + logDirs + " from hbase tables " + BackupServerUtil.join(tableNames) + " to tables " + BackupServerUtil.join(newTableNames)));
        for (int i = 0; i < tableNames.length; ++i) {
            LOG.info((Object)("Restore " + tableNames[i] + " into " + newTableNames[i]));
            Path bulkOutputPath = this.getBulkOutputDir(this.getFileNameCompatibleString(newTableNames[i]));
            String[] playerArgs = new String[]{logDirs, tableNames[i].getNameAsString(), newTableNames[i].getNameAsString()};
            int result = 0;
            int loaderResult = 0;
            try {
                Configuration conf = this.getConf();
                conf.set("wal.bulk.output", bulkOutputPath.toString());
                this.player.setConf(this.getConf());
                result = this.player.run(playerArgs);
                if (this.succeeded(result)) {
                    String[] args;
                    LoadIncrementalHFiles loader = this.createLoader();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Restoring HFiles from directory " + bulkOutputPath));
                    }
                    if (this.failed(loaderResult = loader.run(args = new String[]{bulkOutputPath.toString(), newTableNames[i].getNameAsString()}))) {
                        throw new IOException("Can not restore from backup directory " + logDirs + " (check Hadoop and HBase logs). Bulk loader return code =" + loaderResult);
                    }
                } else {
                    throw new IOException("Can not restore from backup directory " + logDirs + " (check Hadoop/MR and HBase logs). WALPlayer return code =" + result);
                }
                LOG.debug((Object)("Restore Job finished:" + result));
                continue;
            }
            catch (Exception e) {
                throw new IOException("Can not restore from backup directory " + logDirs + " (check Hadoop and HBase logs) ", e);
            }
        }
    }

    private String getFileNameCompatibleString(TableName table) {
        return table.getNamespaceAsString() + "-" + table.getQualifierAsString();
    }

    private boolean failed(int result) {
        return result != 0;
    }

    private boolean succeeded(int result) {
        return result == 0;
    }

    private LoadIncrementalHFiles createLoader() throws IOException {
        Integer milliSecInHour = 3600000;
        Configuration conf = new Configuration(this.getConf());
        conf.setInt("hbase.rpc.timeout", milliSecInHour.intValue());
        conf.setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", Integer.MAX_VALUE);
        LoadIncrementalHFiles loader = null;
        try {
            loader = new LoadIncrementalHFiles(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return loader;
    }

    private Path getBulkOutputDir(String tableName) throws IOException {
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String tmp = conf.get("hbase.tmp.dir");
        Path path = new Path(tmp + "/" + "bulk_output-" + tableName + "-" + EnvironmentEdgeManager.currentTime());
        fs.deleteOnExit(path);
        return path;
    }

    public Configuration getConf() {
        return this.player.getConf();
    }

    public void setConf(Configuration conf) {
        this.player.setConf(conf);
    }
}

