/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DeleteTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.DeleteTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(DeleteTableProcedure.class);
    private List<HRegionInfo> regions;
    private UserGroupInformation user;
    private TableName tableName;
    private final ProcedurePrepareLatch syncLatch;

    public DeleteTableProcedure() {
        this.syncLatch = null;
    }

    public DeleteTableProcedure(MasterProcedureEnv env, TableName tableName) throws IOException {
        this(env, tableName, null);
    }

    public DeleteTableProcedure(MasterProcedureEnv env, TableName tableName, ProcedurePrepareLatch syncLatch) throws IOException {
        this.tableName = tableName;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.syncLatch = syncLatch;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteTableState state) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case DELETE_TABLE_PRE_OPERATION: {
                    boolean deletable = this.prepareDelete(env);
                    ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
                    if (!deletable) {
                        assert (this.isFailed()) : "the delete should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.debug((Object)("waiting for '" + this.getTableName() + "' regions in transition"));
                    this.regions = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
                    assert (this.regions != null && !this.regions.isEmpty()) : "unexpected 0 regions";
                    ProcedureSyncWait.waitRegionInTransition(env, this.regions);
                    this.preDelete(env);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_REMOVE_FROM_META);
                    break;
                }
                case DELETE_TABLE_REMOVE_FROM_META: {
                    LOG.debug((Object)("delete '" + this.getTableName() + "' regions from META"));
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), this.regions);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_CLEAR_FS_LAYOUT);
                    break;
                }
                case DELETE_TABLE_CLEAR_FS_LAYOUT: {
                    LOG.debug((Object)("delete '" + this.getTableName() + "' from filesystem"));
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UPDATE_DESC_CACHE);
                    this.regions = null;
                    break;
                }
                case DELETE_TABLE_UPDATE_DESC_CACHE: {
                    LOG.debug((Object)("delete '" + this.getTableName() + "' descriptor"));
                    DeleteTableProcedure.deleteTableDescriptorCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UNASSIGN_REGIONS);
                    break;
                }
                case DELETE_TABLE_UNASSIGN_REGIONS: {
                    LOG.debug((Object)("delete '" + this.getTableName() + "' assignment state"));
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_POST_OPERATION);
                    break;
                }
                case DELETE_TABLE_POST_OPERATION: {
                    this.postDelete(env);
                    LOG.debug((Object)("delete '" + this.getTableName() + "' completed"));
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | HBaseException e) {
            LOG.warn((Object)("Retriable error trying to delete table=" + this.getTableName() + " state=" + state), e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Interrupted trying to delete table=" + this.getTableName() + " state=" + state), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DeleteTableState state) {
        if (state == MasterProcedureProtos.DeleteTableState.DELETE_TABLE_PRE_OPERATION) {
            ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected MasterProcedureProtos.DeleteTableState getState(int stateId) {
        return MasterProcedureProtos.DeleteTableState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DeleteTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DeleteTableState getInitialState() {
        return MasterProcedureProtos.DeleteTableState.DELETE_TABLE_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.DELETE;
    }

    public boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isInitialized()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.getTableName(), "delete table");
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.getTableName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(")");
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.DeleteTableStateData.Builder state = MasterProcedureProtos.DeleteTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        if (this.regions != null) {
            for (HRegionInfo hri : this.regions) {
                state.addRegionInfo(HRegionInfo.convert((HRegionInfo)hri));
            }
        }
        state.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.DeleteTableStateData state = MasterProcedureProtos.DeleteTableStateData.parseDelimitedFrom((InputStream)stream);
        this.user = MasterProcedureUtil.toUserInfo(state.getUserInfo());
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)state.getTableName());
        if (state.getRegionInfoCount() == 0) {
            this.regions = null;
        } else {
            this.regions = new ArrayList<HRegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.regions.add(HRegionInfo.convert((HBaseProtos.RegionInfo)hri));
            }
        }
    }

    private boolean prepareDelete(MasterProcedureEnv env) throws IOException {
        try {
            env.getMasterServices().checkTableModifiable(this.tableName);
        }
        catch (TableNotDisabledException | TableNotFoundException e) {
            this.setFailure("master-delete-table", e);
            return false;
        }
        return true;
    }

    private boolean preDelete(MasterProcedureEnv env) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            final TableName tableName = this.tableName;
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.preDeleteTableHandler(tableName);
                    return null;
                }
            });
        }
        return true;
    }

    private void postDelete(MasterProcedureEnv env) throws IOException, InterruptedException {
        DeleteTableProcedure.deleteTableStates(env, this.tableName);
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            final TableName tableName = this.tableName;
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.postDeleteTableHandler(tableName);
                    return null;
                }
            });
        }
    }

    protected static void deleteFromFs(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regions, boolean archive) throws IOException {
        Path mobTableDir;
        Path regionDir;
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        FileSystem fs = mfs.getFileSystem();
        Path tempdir = mfs.getTempDir();
        Path tableDir = FSUtils.getTableDir(mfs.getRootDir(), tableName);
        Path tempTableDir = FSUtils.getTableDir(tempdir, tableName);
        if (fs.exists(tableDir)) {
            if (!fs.exists(tempdir) && !fs.mkdirs(tempdir)) {
                throw new IOException("HBase temp directory '" + tempdir + "' creation failure.");
            }
            if (!fs.exists(tempTableDir.getParent()) && !fs.mkdirs(tempTableDir.getParent())) {
                throw new IOException("HBase temp directory '" + tempdir + "' creation failure.");
            }
            if (!fs.rename(tableDir, tempTableDir)) {
                if (fs.exists(tempTableDir)) {
                    FileStatus[] files = fs.listStatus(tempdir);
                    if (files != null && files.length > 0) {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isDir()) continue;
                            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, files[i].getPath());
                        }
                    }
                    fs.delete(tempdir, true);
                }
                throw new IOException("Unable to move '" + tableDir + "' to temp '" + tempTableDir + "'");
            }
        }
        if (archive) {
            for (HRegionInfo hri : regions) {
                LOG.debug((Object)("Archiving region " + hri.getRegionNameAsString() + " from FS"));
                HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, HRegion.getRegionDir(tempTableDir, hri.getEncodedName()));
            }
            LOG.debug((Object)("Table '" + tableName + "' archived!"));
        }
        if (fs.exists(regionDir = new Path(mobTableDir = FSUtils.getTableDir(new Path(mfs.getRootDir(), "mobdir"), tableName), MobUtils.getMobRegionInfo(tableName).getEncodedName()))) {
            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), mobTableDir, regionDir);
        }
        if (!fs.delete(tempTableDir, true) && fs.exists(tempTableDir)) {
            throw new IOException("Couldn't delete " + tempTableDir);
        }
        if (mobTableDir != null && fs.exists(mobTableDir) && !fs.delete(mobTableDir, true)) {
            throw new IOException("Couldn't delete mob dir " + mobTableDir);
        }
    }

    private static void cleanAnyRemainingRows(MasterProcedureEnv env, TableName tableName) throws IOException {
        ClusterConnection connection = env.getMasterServices().getConnection();
        Scan tableScan = MetaTableAccessor.getScanForTableName((TableName)tableName);
        try (HTableInterface metaTable = connection.getTable(TableName.META_TABLE_NAME);){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            try (ResultScanner resScanner = metaTable.getScanner(tableScan);){
                for (Result result : resScanner) {
                    deletes.add(new Delete(result.getRow()));
                }
            }
            if (!deletes.isEmpty()) {
                LOG.warn((Object)("Deleting some vestigal " + deletes.size() + " rows of " + tableName + " from " + TableName.META_TABLE_NAME));
                metaTable.delete(deletes);
            }
        }
    }

    protected static void deleteFromMeta(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regions) throws IOException {
        MetaTableAccessor.deleteRegions((Connection)env.getMasterServices().getConnection(), regions);
        DeleteTableProcedure.cleanAnyRemainingRows(env, tableName);
    }

    protected static void deleteAssignmentState(MasterProcedureEnv env, TableName tableName) throws HBaseException, IOException {
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        LOG.debug((Object)("Removing '" + tableName + "' from region states."));
        am.getRegionStates().tableDeleted(tableName);
        LOG.debug((Object)("Marking '" + tableName + "' as deleted."));
        am.getTableStateManager().setDeletedTable(tableName);
    }

    protected static void deleteTableDescriptorCache(MasterProcedureEnv env, TableName tableName) throws IOException {
        LOG.debug((Object)("Removing '" + tableName + "' descriptor."));
        env.getMasterServices().getTableDescriptors().remove(tableName);
    }

    protected static void deleteTableStates(MasterProcedureEnv env, TableName tableName) throws IOException {
        if (!tableName.isSystemTable()) {
            ProcedureSyncWait.getMasterQuotaManager(env).removeTableFromNamespaceQuota(tableName);
        }
    }
}

