/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.transexecutor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultMeta;
import org.pentaho.di.trans.steps.rowstoresult.RowsToResultMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransExecutorStepAnalyzer
extends StepAnalyzer<TransExecutorMeta> {
    public static final String TRANSFORMATION_TO_EXECUTE = "transformationToExecute";
    public static final String EXECUTION_RESULTS_TARGET = "executionResultsTarget";
    public static final String OUTPUT_ROWS_TARGET = "outputRowsTarget";
    public static final String RESULT_FILES_TARGET = "resultFilesTarget";
    private Logger log = LoggerFactory.getLogger(TransExecutorStepAnalyzer.class);

    protected Set<StepField> getUsedFields(TransExecutorMeta meta) {
        return this.getInputs().getFieldNames();
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        return false;
    }

    protected void customAnalyze(TransExecutorMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        String transPath = meta.getFileName();
        TransMeta subTransMeta = null;
        Repository repo = this.parentTransMeta.getRepository();
        switch (meta.getSpecificationMethod()) {
            case FILENAME: {
                transPath = this.parentTransMeta.environmentSubstitute(meta.getFileName());
                try {
                    String normalized = KettleAnalyzerUtil.normalizeFilePath((String)transPath);
                    subTransMeta = this.getSubTransMeta(normalized);
                    transPath = normalized;
                    break;
                }
                catch (Exception e) {
                    throw new MetaverseAnalyzerException("Sub transformation can not be found - " + transPath, (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                if (repo != null) {
                    String dir = this.parentTransMeta.environmentSubstitute(meta.getDirectoryPath());
                    String file = this.parentTransMeta.environmentSubstitute(meta.getTransName());
                    try {
                        RepositoryDirectoryInterface rdi = repo.findDirectory(dir);
                        subTransMeta = repo.loadTransformation(file, rdi, null, true, null);
                        transPath = subTransMeta.getPathAndName() + "." + subTransMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found in repository - " + file, (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
            case REPOSITORY_BY_REFERENCE: {
                if (repo != null) {
                    try {
                        subTransMeta = repo.loadTransformation(meta.getTransObjectId(), null);
                        transPath = subTransMeta.getPathAndName() + "." + subTransMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found by reference - " + meta.getTransObjectId(), (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
        }
        MetaverseComponentDescriptor ds = new MetaverseComponentDescriptor(subTransMeta.getName(), "Transformation", this.descriptor.getNamespace().getParentNamespace());
        IMetaverseNode transformationNode = this.createNodeFromDescriptor((IComponentDescriptor)ds);
        transformationNode.setProperty("namespace", (Object)ds.getNamespaceId());
        transformationNode.setProperty("path", (Object)transPath);
        transformationNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        this.metaverseBuilder.addLink(node, "executes", transformationNode);
        this.connectToSubTransInputFields(meta, subTransMeta, transformationNode, this.descriptor);
        this.connectToSubTransOutputFields(meta, subTransMeta, transformationNode, this.descriptor);
        node.setProperty(TRANSFORMATION_TO_EXECUTE, (Object)transPath);
        if (StringUtils.isNotEmpty((String)meta.getExecutionResultTargetStep())) {
            node.setProperty(EXECUTION_RESULTS_TARGET, (Object)meta.getExecutionResultTargetStep());
        }
        if (StringUtils.isNotEmpty((String)meta.getOutputRowsSourceStep())) {
            node.setProperty(OUTPUT_ROWS_TARGET, (Object)meta.getOutputRowsSourceStep());
        }
        if (StringUtils.isNotEmpty((String)meta.getResultFilesTargetStep())) {
            node.setProperty(RESULT_FILES_TARGET, (Object)meta.getResultFilesTargetStep());
        }
    }

    protected TransMeta getSubTransMeta(String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        FileInputStream fis = new FileInputStream(filePath);
        return new TransMeta((InputStream)fis, null, true, null, null);
    }

    protected void connectToSubTransOutputFields(TransExecutorMeta meta, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        IMetaverseNode outNode;
        String fieldName;
        int i;
        String outputStep;
        if (meta.getOutputRowsSourceStep() != null) {
            outputStep = meta.getOutputRowsSourceStep();
            for (i = 0; i < meta.getOutputRowsField().length; ++i) {
                fieldName = meta.getOutputRowsField()[i];
                outNode = this.getOutputs().findNode(outputStep, fieldName);
                if (outNode == null) continue;
                this.linkResultFieldToSubTrans(outNode, subTransMeta, subTransNode, descriptor);
            }
        }
        if (meta.getExecutorsOutputStep() != null) {
            outputStep = meta.getExecutorsOutputStep();
            for (i = 0; i < meta.getOutputRowsField().length; ++i) {
                fieldName = meta.getOutputRowsField()[i];
                outNode = this.getOutputs().findNode(outputStep, fieldName);
                if (outNode == null) continue;
                this.linkResultFieldToSubTrans(outNode, subTransMeta, subTransNode, descriptor);
            }
        }
    }

    protected void linkResultFieldToSubTrans(IMetaverseNode streamFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        List steps = subTransMeta.getSteps();
        if (!CollectionUtils.isEmpty((Collection)steps)) {
            for (StepMeta step : steps) {
                if (!(step.getStepMetaInterface() instanceof RowsToResultMeta)) continue;
                RowsToResultMeta rtrm = (RowsToResultMeta)step.getStepMetaInterface();
                MetaverseComponentDescriptor stepDescriptor = new MetaverseComponentDescriptor(step.getName(), "Transformation Step", subTransNode, descriptor.getContext());
                IMetaverseNode subTransStepNode = this.createNodeFromDescriptor((IComponentDescriptor)stepDescriptor);
                try {
                    RowMetaInterface rowMetaInterface = rtrm.getParentStepMeta().getParentTransMeta().getStepFields(step);
                    for (int i = 0; i < rowMetaInterface.getFieldNames().length; ++i) {
                        String field = rowMetaInterface.getFieldNames()[i];
                        if (!streamFieldNode.getName().equals(field)) continue;
                        MetaverseComponentDescriptor stepFieldDescriptor = new MetaverseComponentDescriptor(field, "Transformation Stream field", subTransStepNode, descriptor.getContext());
                        IMetaverseNode subTransField = this.createFieldNode((IComponentDescriptor)stepFieldDescriptor, rowMetaInterface.getValueMeta(i), "_none_", false);
                        this.metaverseBuilder.addLink(subTransField, "derives", streamFieldNode);
                    }
                }
                catch (KettleStepException e) {
                    this.log.warn("Could not get step fields of RowsToResult step in sub transformation - " + subTransMeta.getName(), (Throwable)e);
                }
            }
        }
    }

    protected void connectToSubTransInputFields(TransExecutorMeta meta, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        Set incomingFields = this.getInputs().getFieldNames();
        for (StepField field : incomingFields) {
            IMetaverseNode inputNode = this.getInputs().findNode(field);
            this.linkUsedFieldToSubTrans(inputNode, subTransMeta, subTransNode, descriptor);
        }
    }

    protected void linkUsedFieldToSubTrans(IMetaverseNode originalFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        List steps = subTransMeta.getSteps();
        if (!CollectionUtils.isEmpty((Collection)steps)) {
            for (StepMeta step : steps) {
                if (!(step.getStepMetaInterface() instanceof RowsFromResultMeta)) continue;
                RowsFromResultMeta rfrm = (RowsFromResultMeta)step.getStepMetaInterface();
                MetaverseComponentDescriptor stepDescriptor = new MetaverseComponentDescriptor("_none_", "Transformation Step", subTransNode, descriptor.getContext());
                IMetaverseNode subTransStepNode = this.createNodeFromDescriptor((IComponentDescriptor)stepDescriptor);
                try {
                    RowMetaInterface rowMetaInterface = rfrm.getParentStepMeta().getParentTransMeta().getStepFields(step);
                    for (int i = 0; i < rowMetaInterface.getFieldNames().length; ++i) {
                        String field = rowMetaInterface.getFieldNames()[i];
                        if (!originalFieldNode.getName().equals(field)) continue;
                        MetaverseComponentDescriptor stepFieldDescriptor = new MetaverseComponentDescriptor(field, "Transformation Stream field", subTransStepNode, descriptor.getContext());
                        IMetaverseNode subTransField = this.createFieldNode((IComponentDescriptor)stepFieldDescriptor, rowMetaInterface.getValueMeta(i), step.getName(), false);
                        this.metaverseBuilder.addLink(originalFieldNode, "derives", subTransField);
                    }
                }
                catch (KettleStepException e) {
                    this.log.warn("Could not get step fields of RowsFromResult step in sub transformation - " + subTransMeta.getName(), (Throwable)e);
                }
            }
        }
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(TransExecutorMeta meta) {
        HashMap<String, RowMetaInterface> outputFields = new HashMap<String, RowMetaInterface>();
        String[] nextStepNames = this.parentTransMeta.getNextStepNames(this.parentStepMeta);
        for (int i = 0; i < nextStepNames.length; ++i) {
            String nextStepName = nextStepNames[i];
            StepMeta step = this.parentTransMeta.findStep(nextStepName);
            ProgressNullMonitorListener progressMonitor = new ProgressNullMonitorListener();
            try {
                RowMetaInterface prevStepFields = this.parentTransMeta.getPrevStepFields(step, (ProgressMonitorListener)progressMonitor);
                outputFields.put(nextStepName, prevStepFields);
                progressMonitor.done();
                continue;
            }
            catch (KettleStepException e) {
                this.log.warn("Could not get step fields for " + nextStepName, (Throwable)e);
            }
        }
        return outputFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(TransExecutorMeta.class);
        return supportedSteps;
    }

    protected void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    protected void setParentStepMeta(StepMeta parentStepMeta) {
        this.parentStepMeta = parentStepMeta;
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, ValueMetaInterface fieldMeta, String targetStepName, boolean addTheNode) {
        return super.createFieldNode(fieldDescriptor, fieldMeta, targetStepName, addTheNode);
    }
}

