/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.dictionary.MetaverseLink;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseReader;
import org.pentaho.metaverse.graph.GraphCsvWriter;
import org.pentaho.metaverse.graph.GraphMLWriter;
import org.pentaho.metaverse.graph.GraphPath;
import org.pentaho.metaverse.graph.GraphSONWriter;
import org.pentaho.metaverse.graph.GraphUtil;
import org.pentaho.metaverse.impl.MetaverseNode;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintsGraphMetaverseReader
implements IMetaverseReader {
    private static final long serialVersionUID = -3813738340722424284L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintsGraphMetaverseReader.class);
    private Graph graph;

    public BlueprintsGraphMetaverseReader(Graph graph) {
        this.graph = graph;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public IMetaverseNode findNode(String id) {
        Vertex vertex = this.getGraph().getVertex((Object)id);
        if (vertex == null) {
            return null;
        }
        MetaverseUtil.enhanceVertex(vertex);
        MetaverseNode node = new MetaverseNode(vertex);
        return node;
    }

    public List<IMetaverseNode> findNodes(String property, String value) {
        Iterable vertices = this.getGraph().getVertices(property, (Object)value);
        if (vertices == null) {
            return null;
        }
        ArrayList<IMetaverseNode> result = new ArrayList<IMetaverseNode>();
        Iterator verticesIt = vertices.iterator();
        while (verticesIt.hasNext()) {
            MetaverseNode node = new MetaverseNode((Vertex)verticesIt.next());
            result.add(node);
        }
        return result;
    }

    public IMetaverseLink findLink(String leftNodeID, String linkType, String rightNodeID, Direction direction) {
        Vertex vertex = this.getGraph().getVertex((Object)leftNodeID);
        if (vertex == null) {
            return null;
        }
        Iterable edges = linkType == null ? vertex.getEdges(direction, new String[0]) : vertex.getEdges(direction, new String[]{linkType});
        MetaverseLink link = new MetaverseLink();
        MetaverseNode node1 = new MetaverseNode(vertex);
        Direction opDirection = direction == Direction.IN ? Direction.OUT : Direction.IN;
        Vertex vertex2 = null;
        if (rightNodeID != null) {
            for (Edge edge : edges) {
                if (!rightNodeID.equals((String)edge.getVertex(opDirection).getId())) continue;
                vertex2 = edge.getVertex(opDirection);
                MetaverseNode node2 = new MetaverseNode(vertex2);
                String label = edge.getLabel();
                link.setLabel(label);
                String localized = Messages.getString("USER.linktype." + label);
                if (!localized.startsWith("!")) {
                    link.setProperty("typeLocale", (Object)localized);
                }
                if (direction == Direction.OUT) {
                    link.setFromNode((IMetaverseNode)node1);
                    link.setToNode((IMetaverseNode)node2);
                } else {
                    link.setFromNode((IMetaverseNode)node2);
                    link.setToNode((IMetaverseNode)node1);
                }
                return link;
            }
        }
        return null;
    }

    public Graph getMetaverse() {
        Graph graph = this.getGraph();
        graph = this.enhanceGraph(graph);
        return graph;
    }

    public String exportToXml() {
        return this.exportFormat("xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportFormat(String format) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.exportToStream(format, out);
        }
        catch (IOException e) {
            LOGGER.error(Messages.getString("ERROR.Graph.Export"), (Throwable)e);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                LOGGER.error(Messages.getString("ERROR.Graph.Export"), (Throwable)e);
            }
        }
        return ((Object)out).toString();
    }

    public void exportToStream(String format, OutputStream out) throws IOException {
        String fmt = format;
        if (fmt == null) {
            fmt = "xml";
        }
        Graph graph = this.getGraph();
        graph = this.enhanceGraph(graph);
        if (fmt.equalsIgnoreCase("xml")) {
            GraphMLWriter writer = new GraphMLWriter();
            writer.outputGraph(graph, out);
        } else if (fmt.equalsIgnoreCase("json")) {
            GraphSONWriter writer = new GraphSONWriter();
            writer.outputGraph(graph, out);
        } else if (fmt.equalsIgnoreCase("csv")) {
            GraphCsvWriter writer = new GraphCsvWriter();
            writer.outputGraph(graph, out);
        }
    }

    public Graph search(List<String> resultTypes, List<String> startNodeIDs, boolean shortestOnly) {
        TinkerGraph g = new TinkerGraph();
        for (String startNodeID : startNodeIDs) {
            if (this.graph == null) continue;
            Vertex startVertex = this.graph.getVertex((Object)startNodeID);
            GraphPath path = new GraphPath();
            HashSet<Object> done = new HashSet<Object>();
            HashMap<Object, GraphPath> shortestPaths = new HashMap<Object, GraphPath>();
            this.traverseGraph(startVertex, this.graph, resultTypes, path, done, shortestPaths, Direction.IN, shortestOnly);
            done = new HashSet();
            this.traverseGraph(startVertex, this.graph, resultTypes, path, done, shortestPaths, Direction.OUT, shortestOnly);
            for (Map.Entry entry : shortestPaths.entrySet()) {
                GraphPath shortPath = (GraphPath)entry.getValue();
                shortPath.addToGraph((Graph)g);
            }
        }
        g = this.enhanceGraph((Graph)g);
        return g;
    }

    private void traverseGraph(Vertex startVertex, Graph subGraph, List<String> resultTypes, GraphPath path, Set<Object> done, Map<Object, GraphPath> shortestPaths, Direction direction, boolean shortestOnly) {
        Vertex nextVertex;
        boolean isTargetType;
        boolean bl = isTargetType = resultTypes == null || resultTypes.size() == 0 || resultTypes.contains(startVertex.getProperty("type"));
        if (!isTargetType && done.contains(startVertex.getId())) {
            return;
        }
        path.addVertex(startVertex);
        if (isTargetType) {
            if (shortestOnly) {
                GraphPath shortestPath = shortestPaths.get(startVertex.getId());
                if (shortestPath == null || path.getLength() < shortestPath.getLength()) {
                    shortestPaths.put(startVertex.getId(), path.clone());
                    if (done.contains(startVertex.getId())) {
                        path.pop();
                        return;
                    }
                }
            } else {
                shortestPaths.put(path.toString(), path.clone());
            }
        }
        done.add(startVertex.getId());
        if (direction == Direction.IN) {
            for (Edge edge : startVertex.getEdges(Direction.IN, new String[0])) {
                if (done.contains(edge.getId())) continue;
                path.addEdge(edge);
                nextVertex = edge.getVertex(Direction.OUT);
                this.traverseGraph(nextVertex, subGraph, resultTypes, path, done, shortestPaths, direction, shortestOnly);
                path.pop();
            }
        }
        if (direction == Direction.OUT) {
            for (Edge edge : startVertex.getEdges(Direction.OUT, new String[0])) {
                if (done.contains(edge.getId())) continue;
                path.addEdge(edge);
                nextVertex = edge.getVertex(Direction.IN);
                this.traverseGraph(nextVertex, subGraph, resultTypes, path, done, shortestPaths, direction, shortestOnly);
                path.pop();
            }
            if (path.getLength() > 1) {
                for (Edge edge : startVertex.getEdges(Direction.IN, new String[0])) {
                    if (done.contains(edge.getId())) continue;
                    path.addEdge(edge);
                    nextVertex = edge.getVertex(Direction.OUT);
                    this.traverseGraph(nextVertex, subGraph, resultTypes, path, done, shortestPaths, Direction.IN, shortestOnly);
                    path.pop();
                }
            }
        }
        path.pop();
    }

    public Graph getGraph(String id) {
        Vertex root = this.getGraph().getVertex((Object)id);
        if (root == null) {
            return null;
        }
        TinkerGraph g = new TinkerGraph();
        Vertex clone = GraphUtil.cloneVertexIntoGraph(root, (Graph)g);
        this.traceVertices(root, clone, Direction.IN, this.getGraph(), (Graph)g, null);
        this.traceVertices(root, clone, Direction.OUT, this.getGraph(), (Graph)g, null);
        g = this.enhanceGraph((Graph)g);
        return g;
    }

    private void traceVertices(Vertex vertex, Vertex clone, Direction direction, Graph graph1, Graph graph2, Set<String> edgeTypes) {
        Direction opDirection = direction == Direction.IN ? Direction.OUT : Direction.IN;
        for (Edge edge : vertex.getEdges(direction, new String[0])) {
            if (edgeTypes != null && !edgeTypes.contains(edge.getLabel())) continue;
            Vertex nextVertex = edge.getVertex(opDirection);
            Vertex target = GraphUtil.cloneVertexIntoGraph(nextVertex, graph2);
            Vertex node1 = direction == Direction.IN ? target : clone;
            Vertex node2 = direction == Direction.IN ? clone : target;
            String edgeId = (String)node1.getId() + ">" + (String)node2.getId();
            if (graph2.getEdge((Object)edgeId) == null) {
                if (direction == Direction.IN) {
                    graph2.addEdge((Object)edgeId, target, clone, edge.getLabel());
                } else {
                    graph2.addEdge((Object)edgeId, clone, target, edge.getLabel());
                }
            }
            this.traceVertices(nextVertex, target, direction, graph1, graph2, edgeTypes);
            if (direction != Direction.OUT) continue;
            this.traceVertices(nextVertex, target, Direction.IN, graph1, graph2, DictionaryHelper.STRUCTURAL_LINK_TYPES);
        }
    }

    protected Graph enhanceGraph(Graph g) {
        for (Vertex vertex : g.getVertices()) {
            MetaverseUtil.enhanceVertex(vertex);
        }
        for (Edge edge : g.getEdges()) {
            MetaverseUtil.enhanceEdge(edge);
        }
        return g;
    }
}

