/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionPusher {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectionPusher.class);
    private final Map<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
    private MapWork mapWork;

    private void updateMrWork(JobConf job) {
        String plan = HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN);
        if (this.mapWork == null && plan != null && plan.length() > 0) {
            this.mapWork = Utilities.getMapWork((Configuration)job);
            this.pathToPartitionInfo.clear();
            for (Map.Entry<String, PartitionDesc> entry : this.mapWork.getPathToPartitionInfo().entrySet()) {
                this.pathToPartitionInfo.put(new Path(entry.getKey()).toUri().getPath(), entry.getValue());
            }
        }
    }

    @Deprecated
    private void pushProjectionsAndFilters(JobConf jobConf, String splitPath, String splitPathWithNoSchema) {
        if (this.mapWork == null) {
            return;
        }
        if (this.mapWork.getPathToAliases() == null) {
            return;
        }
        HashSet aliases = new HashSet();
        for (Map.Entry<String, ArrayList<String>> entry : this.mapWork.getPathToAliases().entrySet()) {
            String key = new Path(entry.getKey()).toUri().getPath();
            if (!splitPath.equals(key) && !splitPathWithNoSchema.equals(key)) continue;
            aliases.addAll(entry.getValue());
        }
        boolean allColumnsNeeded = false;
        boolean noFilters = false;
        HashSet<Integer> neededColumnIDs = new HashSet<Integer>();
        ArrayList<ExprNodeGenericFuncDesc> filterExprs = new ArrayList<ExprNodeGenericFuncDesc>();
        RowSchema rowSchema = null;
        for (String alias : aliases) {
            Operator<? extends OperatorDesc> op = this.mapWork.getAliasToWork().get(alias);
            if (op == null || !(op instanceof TableScanOperator)) continue;
            TableScanOperator ts = (TableScanOperator)op;
            if (ts.getNeededColumnIDs() == null) {
                allColumnsNeeded = true;
            } else {
                neededColumnIDs.addAll(ts.getNeededColumnIDs());
            }
            rowSchema = ts.getSchema();
            ExprNodeGenericFuncDesc filterExpr = ts.getConf() == null ? null : ((TableScanDesc)ts.getConf()).getFilterExpr();
            noFilters = filterExpr == null;
            filterExprs.add(filterExpr);
        }
        ExprNodeGenericFuncDesc tableFilterExpr = null;
        if (!noFilters) {
            try {
                for (ExprNodeGenericFuncDesc filterExpr : filterExprs) {
                    if (tableFilterExpr == null) {
                        tableFilterExpr = filterExpr;
                        continue;
                    }
                    tableFilterExpr = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), Arrays.asList(tableFilterExpr, filterExpr));
                }
            }
            catch (UDFArgumentException ex) {
                LOG.debug("Turn off filtering due to " + ex);
                tableFilterExpr = null;
            }
        }
        if (!allColumnsNeeded) {
            if (!neededColumnIDs.isEmpty()) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobConf, new ArrayList<Integer>(neededColumnIDs));
            }
        } else {
            ColumnProjectionUtils.setFullyReadColumns((Configuration)jobConf);
        }
        this.pushFilters(jobConf, rowSchema, tableFilterExpr);
    }

    private void pushFilters(JobConf jobConf, RowSchema rowSchema, ExprNodeGenericFuncDesc filterExpr) {
        Utilities.setColumnNameList(jobConf, rowSchema);
        if (filterExpr == null) {
            LOG.debug("Not pushing filters because FilterExpr is null");
            return;
        }
        String filterText = filterExpr.getExprString();
        String filterExprSerialized = SerializationUtilities.serializeExpression(filterExpr);
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", filterExprSerialized);
    }

    @Deprecated
    public JobConf pushProjectionsAndFilters(JobConf jobConf, Path path) throws IOException {
        this.updateMrWork(jobConf);
        JobConf cloneJobConf = new JobConf((Configuration)jobConf);
        PartitionDesc part = this.pathToPartitionInfo.get(path.toString());
        if (part != null && part.getTableDesc() != null) {
            Utilities.copyTableJobPropertiesToConf(part.getTableDesc(), (Configuration)cloneJobConf);
        }
        this.pushProjectionsAndFilters(cloneJobConf, path.toString(), path.toUri().getPath());
        return cloneJobConf;
    }
}

