/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointRepository {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointRepository.class);
    private final Map<ServiceReference, Map<RemoteServiceAdmin, Collection<EndpointDescription>>> exportedServices = new LinkedHashMap<ServiceReference, Map<RemoteServiceAdmin, Collection<EndpointDescription>>>();
    private EndpointListener notifier;

    public void setNotifier(EndpointListener notifier) {
        this.notifier = notifier;
    }

    public synchronized List<EndpointDescription> removeRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        LOG.debug("RemoteServiceAdmin removed: {}", (Object)rsa.getClass().getName());
        ArrayList<EndpointDescription> removedEndpoints = new ArrayList<EndpointDescription>();
        for (Map<RemoteServiceAdmin, Collection<EndpointDescription>> exports : this.exportedServices.values()) {
            Collection<EndpointDescription> endpoints = exports.get(rsa);
            if (endpoints == null) continue;
            removedEndpoints.addAll(endpoints);
            exports.remove(rsa);
        }
        this.endpointsRemoved(removedEndpoints);
        return removedEndpoints;
    }

    public synchronized void removeService(ServiceReference sref) {
        ArrayList<EndpointDescription> removedEndpoints = new ArrayList<EndpointDescription>();
        Map<RemoteServiceAdmin, Collection<EndpointDescription>> rsaToEndpoints = this.exportedServices.get(sref);
        if (rsaToEndpoints != null) {
            for (Collection<EndpointDescription> endpoints : rsaToEndpoints.values()) {
                removedEndpoints.addAll(endpoints);
            }
            this.exportedServices.remove(sref);
        }
        this.endpointsRemoved(removedEndpoints);
    }

    public synchronized void addService(ServiceReference sref) {
        if (!this.exportedServices.containsKey(sref)) {
            LOG.info("Marking service from bundle {} for export", (Object)sref.getBundle().getSymbolicName());
            this.exportedServices.put(sref, new LinkedHashMap());
        }
    }

    public synchronized void addEndpoints(ServiceReference sref, RemoteServiceAdmin rsa, List<EndpointDescription> endpoints) {
        this.addService(sref);
        Map<RemoteServiceAdmin, Collection<EndpointDescription>> exports = this.exportedServices.get(sref);
        exports.put(rsa, endpoints);
        this.endpointsAdded(endpoints);
    }

    synchronized boolean isAlreadyExportedForRsa(ServiceReference sref, RemoteServiceAdmin rsa) {
        Map<RemoteServiceAdmin, Collection<EndpointDescription>> exports = this.exportedServices.get(sref);
        return exports != null && exports.containsKey(rsa);
    }

    public synchronized Collection<EndpointDescription> getAllEndpoints() {
        ArrayList<EndpointDescription> allEndpoints = new ArrayList<EndpointDescription>();
        for (Map<RemoteServiceAdmin, Collection<EndpointDescription>> exports : this.exportedServices.values()) {
            for (Collection<EndpointDescription> endpoints : exports.values()) {
                allEndpoints.addAll(endpoints);
            }
        }
        return allEndpoints;
    }

    public synchronized Set<ServiceReference> getServicesToBeExportedFor(RemoteServiceAdmin rsa) {
        HashSet<ServiceReference> servicesToBeExported = new HashSet<ServiceReference>();
        for (Map.Entry<ServiceReference, Map<RemoteServiceAdmin, Collection<EndpointDescription>>> entry : this.exportedServices.entrySet()) {
            if (entry.getValue().containsKey(rsa)) continue;
            servicesToBeExported.add(entry.getKey());
        }
        return servicesToBeExported;
    }

    private void endpointsAdded(List<EndpointDescription> endpoints) {
        for (EndpointDescription epd : endpoints) {
            this.notifier.endpointAdded(epd, null);
        }
    }

    private void endpointsRemoved(List<EndpointDescription> endpoints) {
        for (EndpointDescription epd : endpoints) {
            this.notifier.endpointRemoved(epd, null);
        }
    }
}

