/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.pigstats.ScriptState;

public class PigATSClient {
    public static final String ENTITY_TYPE = "PIG_SCRIPT_ID";
    public static final String ENTITY_CALLERID = "callerId";
    public static final String CALLER_CONTEXT = "PIG";
    public static final int AUDIT_ID_MAX_LENGTH = 128;
    private static final Log log = LogFactory.getLog((String)PigATSClient.class.getName());
    private static PigATSClient instance;
    private static ExecutorService executor;
    private TimelineClient timelineClient;

    public static synchronized PigATSClient getInstance() {
        if (instance == null) {
            instance = new PigATSClient();
        }
        return instance;
    }

    private PigATSClient() {
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ATS Logger %d").build());
            YarnConfiguration yarnConf = new YarnConfiguration();
            this.timelineClient = TimelineClient.createTimelineClient();
            this.timelineClient.init((Configuration)yarnConf);
            this.timelineClient.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PigATSClient.this.timelineClient.stop();
                executor.shutdownNow();
                executor = null;
            }
        });
        log.info((Object)"Created ATS Hook");
    }

    public static String getPigAuditId(PigContext context) {
        String auditId;
        if (context.getProperties().get("pig.script.id") != null) {
            auditId = (String)context.getProperties().get("pig.script.id");
        } else {
            ScriptState ss = ScriptState.get();
            String filename = ss.getFileName().isEmpty() ? "default" : new File(ss.getFileName()).getName();
            auditId = "PIG-" + filename + "-" + ss.getId();
        }
        return auditId.substring(0, Math.min(auditId.length(), 128));
    }

    public synchronized void logEvent(final ATSEvent event) {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                TimelineEntity entity = new TimelineEntity();
                entity.setEntityId(event.pigScriptId);
                entity.setEntityType(PigATSClient.ENTITY_TYPE);
                entity.addPrimaryFilter(PigATSClient.ENTITY_CALLERID, (Object)(event.callerId != null ? event.callerId : "default"));
                try {
                    PigATSClient.this.timelineClient.putEntities(new TimelineEntity[]{entity});
                }
                catch (Exception e) {
                    log.info((Object)("Failed to submit plan to ATS: " + e.getMessage()));
                }
            }
        });
    }

    public static class ATSEvent {
        String callerId;
        String pigScriptId;

        public ATSEvent(String pigAuditId, String callerId) {
            this.pigScriptId = pigAuditId;
            this.callerId = callerId;
        }
    }
}

