/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.daemon.spark.executor.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.pentaho.daemon.spark.executor.api.SparkExecutor;
import org.pentaho.daemon.spark.executor.impl.SparkConfigGenerator;
import org.pentaho.pdi.engine.daemon.app.api.SparkConstants;
import org.pentaho.pdi.engine.daemon.app.service.DaemonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExecutorImpl
implements SparkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SparkExecutorImpl.class);
    private final DaemonConfiguration config;

    public SparkExecutorImpl(DaemonConfiguration config) {
        this.config = config;
    }

    @Override
    public SparkAppHandle execute(String serviceId, Principal actingPrincipal) {
        if (actingPrincipal == null) {
            throw new RuntimeException("No acting principal supplied.");
        }
        try {
            boolean isYarn = this.config.getSparkMaster().equalsIgnoreCase("yarn");
            File confDir = new File(this.config.getSparkHome(), "kettleConf");
            File dataIntegrationHome = new File(this.config.getSparkApp());
            HashMap<String, String> env = new HashMap<String, String>();
            env.put(SparkConstants.SPARK_HOME, this.config.getSparkHome());
            env.put(SparkConstants.SPARK_CONF_DIR, confDir.toString());
            env.put(SparkConstants.HADOOP_CONF_DIR, this.config.getHadoopConfDir());
            env.put(SparkConstants.HADOOP_USER_NAME, this.config.getHadoopUser());
            SparkLauncher sparkLauncher = isYarn ? this.yarnSparkLauncher(env) : this.localSparkLauncher(env);
            sparkLauncher.setMaster(this.config.getSparkMaster());
            sparkLauncher.directory(dataIntegrationHome);
            sparkLauncher.setVerbose(true);
            Path lib = FileSystems.getDefault().getPath(this.config.getSparkApp(), "lib");
            Path engineJarPath = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().contains("pdi-spark-driver") && path.toString().endsWith(".jar"), new FileVisitOption[0]).findFirst().orElseThrow(() -> new IllegalStateException("Could not find main jar pdi-spark-driver-XXX.jar"));
            List<String> jars = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().endsWith(".jar"), new FileVisitOption[0]).map(p -> p.toFile().getAbsoluteFile().toURI().toString()).collect(Collectors.toList());
            SparkConfigGenerator configGenerator = new SparkConfigGenerator(this.config);
            configGenerator.createSparkDefaults(confDir, jars);
            configGenerator.copyLog4jProperties(confDir);
            sparkLauncher.setAppResource(engineJarPath.toAbsolutePath().toString());
            sparkLauncher.setMainClass(this.config.getSparkAppClass());
            sparkLauncher.addAppArgs(new String[]{serviceId, "dummy"});
            this.addSparkSecurityArgs(actingPrincipal, sparkLauncher);
            sparkLauncher.setVerbose(true);
            return sparkLauncher.startApplication(new SparkAppHandle.Listener[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error trying to launch Spark application from Spark API.", e);
        }
    }

    private void addSparkSecurityArgs(Principal actingPrincipal, SparkLauncher sparkLauncher) {
        if (!this.hasSecurityProperties()) {
            return;
        }
        String keyTabPath = String.format("%s/keytab/%s", this.config.getDaemonHome(), this.config.getKeytabName());
        if (new File(keyTabPath).exists()) {
            if (this.config.disableProxyUser()) {
                sparkLauncher.addSparkArg("--principal", this.config.getKerberosPrincipal());
                sparkLauncher.addSparkArg("--keytab", keyTabPath);
            } else {
                sparkLauncher.addSparkArg("--proxy-user", actingPrincipal.getName());
            }
        }
    }

    private boolean hasSecurityProperties() {
        if (this.config.disableProxyUser() && this.config.getKerberosPrincipal() == null) {
            LOG.warn("Proxy user has been disabled with no Kerberos principal defined");
            return false;
        }
        if (this.config.getKeytabName() == null) {
            LOG.warn("No keytab name has been set for Kerberos authentication");
            return false;
        }
        return true;
    }

    private SparkLauncher localSparkLauncher(Map<String, String> env) {
        SparkLauncher sparkLauncher = new SparkLauncher(env);
        return sparkLauncher;
    }

    private SparkLauncher yarnSparkLauncher(Map<String, String> env) {
        SparkLauncher sparkLauncher = new SparkLauncher(env);
        sparkLauncher.setDeployMode(this.config.getSparkDeployMode());
        return sparkLauncher;
    }
}

