/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.endpoints;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleAuthException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.model.ErrorModel;
import org.pentaho.di.ui.repo.model.LoginModel;
import org.pentaho.di.ui.repo.model.RepositoryModel;

public class RepositoryEndpoint {
    private static Class<?> PKG = RepositoryConnectController.class;
    public static final String ERROR_401 = "401";
    private RepositoryConnectController controller;

    public RepositoryEndpoint(RepositoryConnectController controller) {
        this.controller = controller;
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    public Response login(LoginModel loginModel) {
        try {
            if (this.controller.isRelogin()) {
                this.controller.reconnectToRepository(loginModel.getUsername(), loginModel.getPassword());
            } else {
                this.controller.connectToRepository(loginModel.getUsername(), loginModel.getPassword());
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            if (e.getMessage().contains(ERROR_401) || e instanceof KettleAuthException) {
                return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidCredentials", (String[])new String[0]))).build();
            }
            return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]))).build();
        }
    }

    @POST
    @Path(value="/add")
    @Consumes(value={"application/json"})
    public Response add(RepositoryModel model) {
        if (this.controller.createRepository(model.getId(), this.controller.modelToMap(model))) {
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]))).build();
    }
}

