/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.BasicSessionCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.security.ProviderUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TemporaryAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider";
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private IOException lookupIOE;

    public TemporaryAWSCredentialsProvider(URI uri, Configuration conf) {
        try {
            Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
            this.accessKey = S3AUtils.lookupPassword(c, "fs.s3a.access.key", null);
            this.secretKey = S3AUtils.lookupPassword(c, "fs.s3a.secret.key", null);
            this.sessionToken = S3AUtils.lookupPassword(c, "fs.s3a.session.token", null);
        }
        catch (IOException e) {
            this.lookupIOE = e;
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.lookupIOE != null) {
            throw new CredentialInitializationException(this.lookupIOE.toString(), this.lookupIOE);
        }
        if (!(StringUtils.isEmpty((String)this.accessKey) || StringUtils.isEmpty((String)this.secretKey) || StringUtils.isEmpty((String)this.sessionToken))) {
            return new BasicSessionCredentials(this.accessKey, this.secretKey, this.sessionToken);
        }
        throw new CredentialInitializationException("Access key, secret key or session token is unset");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

