/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Objects;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NlsString
implements Comparable<NlsString> {
    private final String charsetName;
    private final String value;
    private final Charset charset;
    private final SqlCollation collation;

    public NlsString(String value, String charsetName, SqlCollation collation) {
        assert (value != null);
        if (null != charsetName) {
            this.charsetName = charsetName = charsetName.toUpperCase();
            String javaCharsetName = SqlUtil.translateCharacterSetName(charsetName);
            if (javaCharsetName == null) {
                throw new UnsupportedCharsetException(charsetName);
            }
            this.charset = Charset.forName(javaCharsetName);
            CharsetEncoder encoder = this.charset.newEncoder();
            try {
                encoder.encode(CharBuffer.wrap(value));
            }
            catch (CharacterCodingException ex) {
                throw Static.RESOURCE.charsetEncoding(value, javaCharsetName).ex();
            }
        } else {
            this.charsetName = null;
            this.charset = null;
        }
        this.collation = collation;
        this.value = value;
    }

    public Object clone() {
        return new NlsString(this.value, this.charsetName, this.collation);
    }

    public int hashCode() {
        int h = this.value.hashCode();
        h = Util.hash(h, this.charsetName);
        h = Util.hash(h, this.collation);
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsString)) {
            return false;
        }
        NlsString that = (NlsString)obj;
        return Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.charsetName, (Object)that.charsetName) && Objects.equal((Object)this.collation, (Object)that.collation);
    }

    @Override
    public int compareTo(NlsString other) {
        return this.value.compareTo(other.value);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getValue() {
        return this.value;
    }

    public NlsString rtrim() {
        String trimmed = SqlFunctions.rtrim(this.value);
        if (!trimmed.equals(this.value)) {
            return new NlsString(trimmed, this.charsetName, this.collation);
        }
        return this;
    }

    public String asSql(boolean prefix, boolean suffix) {
        StringBuilder ret = new StringBuilder();
        if (prefix && null != this.charsetName) {
            ret.append("_");
            ret.append(this.charsetName);
        }
        ret.append("'");
        ret.append(Util.replace(this.value, "'", "''"));
        ret.append("'");
        return ret.toString();
    }

    public String toString() {
        return this.asSql(true, true);
    }

    public static NlsString concat(List<NlsString> args) {
        if (args.size() < 2) {
            return args.get(0);
        }
        String charSetName = args.get((int)0).charsetName;
        SqlCollation collation = args.get((int)0).collation;
        int length = args.get((int)0).value.length();
        for (int i = 1; i < args.size(); ++i) {
            NlsString arg = args.get(i);
            length += arg.value.length();
            if (arg.charsetName != null && !arg.charsetName.equals(charSetName)) {
                throw new IllegalArgumentException("mismatched charsets");
            }
            if (arg.collation == null || arg.collation.equals(collation)) continue;
            throw new IllegalArgumentException("mismatched collations");
        }
        StringBuilder sb = new StringBuilder(length);
        for (NlsString arg : args) {
            sb.append(arg.value);
        }
        return new NlsString(sb.toString(), charSetName, collation);
    }

    public NlsString copy(String value) {
        return new NlsString(value, this.charsetName, this.collation);
    }
}

