/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.common;

import com.google.common.annotations.VisibleForTesting;
import com.pentaho.big.data.bundles.impl.shim.common.PluginClassloaderGetter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginRegistry;

public class ShimBridgingClassloader
extends ClassLoader {
    public static final String HADOOP_SPOON_PLUGIN = "HadoopSpoonPlugin";
    private static PluginClassloaderGetter pluginClassloaderGetter = new PluginClassloaderGetter();
    private final BundleWiring bundleWiring;
    private final PublicLoadResolveClassLoader bundleWiringClassloader;

    public ShimBridgingClassloader(ClassLoader parentClassLoader, BundleContext bundleContext) {
        super(parentClassLoader);
        this.bundleWiring = (BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class);
        this.bundleWiringClassloader = new PublicLoadResolveClassLoader(this.bundleWiring.getClassLoader());
    }

    public static Object create(BundleContext bundleContext, String className, List<Object> arguments) throws KettlePluginException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        ShimBridgingClassloader shimBridgingClassloader = new ShimBridgingClassloader(pluginClassloaderGetter.getPluginClassloader(LifecyclePluginType.class.getCanonicalName(), HADOOP_SPOON_PLUGIN), bundleContext);
        Class<?> clazz = Class.forName(className, true, shimBridgingClassloader);
        if (arguments == null || arguments.size() == 0) {
            return clazz.newInstance();
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != arguments.size()) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object o = arguments.get(i);
                if (o == null || parameterTypes[i].isInstance(o)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return constructor.newInstance(arguments.toArray());
        }
        throw new InstantiationException("Unable to find constructor for class " + className + " with arguments " + arguments);
    }

    @VisibleForTesting
    static PluginClassloaderGetter getPluginClassloaderGetter() {
        return pluginClassloaderGetter;
    }

    @VisibleForTesting
    static void setPluginClassloaderGetter(PluginClassloaderGetter pluginClassloaderGetter) {
        ShimBridgingClassloader.pluginClassloaderGetter = pluginClassloaderGetter;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        List entries;
        String translatedName;
        String translatedPath;
        String packageName;
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot >= 0) {
            packageName = name.substring(0, lastIndexOfDot);
            if (this.getPackage(packageName) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            translatedPath = "/" + packageName.replace('.', '/');
            translatedName = name.substring(lastIndexOfDot + 1) + ".class";
        } else {
            packageName = "";
            translatedPath = "/";
            translatedName = name;
        }
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        if ((entries = this.bundleWiring.findEntries(translatedPath, translatedName, 0)).size() == 1) {
            byte[] bytes;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)((URL)entries.get(0)).openStream(), (OutputStream)byteArrayOutputStream);
                bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Unable to define class", e);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException();
    }

    @Override
    public URL getResource(String name) {
        int lastIndexOf = name.lastIndexOf(47);
        List entries = lastIndexOf > 0 ? this.bundleWiring.findEntries(name.substring(0, lastIndexOf), name.substring(lastIndexOf + 1), 0) : this.bundleWiring.findEntries("/", name, 0);
        if (entries.size() == 1) {
            return (URL)entries.get(0);
        }
        URL resource = this.bundleWiringClassloader.getResource(name);
        if (resource == null) {
            resource = super.getResource(name);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        ShimBridgingClassloader shimBridgingClassloader = this;
        synchronized (shimBridgingClassloader) {
            result = this.findLoadedClass(name);
        }
        if (result == null) {
            try {
                result = this.findClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                Class<?> osgiProvidedClass = this.bundleWiringClassloader.loadClass(name, resolve);
                if (osgiProvidedClass.getClassLoader() == PluginRegistry.class.getClassLoader()) {
                    try {
                        return super.loadClass(name, resolve);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return osgiProvidedClass;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    @VisibleForTesting
    static class PublicLoadResolveClassLoader
    extends ClassLoader {
        public PublicLoadResolveClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

