/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.subscribe;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.rsa.discovery.endpoint.EndpointDescriptionParser;
import org.apache.aries.rsa.discovery.zookeeper.util.Utils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceMonitor
implements Watcher,
AsyncCallback.StatCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceMonitor.class);
    private final String znode;
    private final ZooKeeper zk;
    private final EndpointListener endpointListener;
    private final boolean recursive;
    private volatile boolean closed;
    private Map<String, EndpointDescription> nodes = new HashMap<String, EndpointDescription>();
    private EndpointDescriptionParser parser;

    public InterfaceMonitor(ZooKeeper zk, String objClass, EndpointListener endpointListener, String scope) {
        this.zk = zk;
        this.znode = Utils.getZooKeeperPath(objClass);
        this.recursive = objClass == null || objClass.isEmpty();
        this.endpointListener = endpointListener;
        this.parser = new EndpointDescriptionParser();
        LOG.debug("Creating new InterfaceMonitor {} for scope [{}] and objectClass [{}]", new Object[]{this.recursive ? "(recursive)" : "", scope, objClass});
    }

    public synchronized List<EndpointDescription> getEndpoints() {
        return new ArrayList<EndpointDescription>(this.nodes.values());
    }

    public void start() {
        this.watch();
    }

    private void watch() {
        LOG.debug("registering a ZooKeeper.exists({}) callback", (Object)this.znode);
        this.zk.exists(this.znode, (Watcher)this, (AsyncCallback.StatCallback)this, null);
    }

    public void process(WatchedEvent event) {
        LOG.debug("ZooKeeper watcher callback on node {} for event {}", (Object)this.znode, (Object)event);
        this.processDelta();
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        LOG.debug("ZooKeeper callback on node: {} code: {}", (Object)this.znode, (Object)rc);
        switch (rc) {
            case -101: 
            case 0: {
                this.processDelta();
                return;
            }
            case -112: 
            case -102: 
            case -4: {
                return;
            }
        }
        this.watch();
    }

    private void processDelta() {
        if (this.closed) {
            return;
        }
        if (this.zk.getState() != ZooKeeper.States.CONNECTED) {
            LOG.debug("ZooKeeper connection was already closed! Not processing changed event.");
            return;
        }
        try {
            if (this.zk.exists(this.znode, false) != null) {
                this.zk.getChildren(this.znode, (Watcher)this);
                this.refreshNodes();
            } else {
                LOG.debug("znode {} doesn't exist -> not processing any changes", (Object)this.znode);
            }
        }
        catch (Exception e) {
            if (this.zk.getState() != ZooKeeper.States.CONNECTED) {
                LOG.debug("Error getting Zookeeper data: " + e);
            }
            LOG.error("Error getting ZooKeeper data.", (Throwable)e);
        }
    }

    public synchronized void close() {
        this.closed = true;
        for (EndpointDescription endpoint : this.nodes.values()) {
            this.endpointListener.endpointRemoved(endpoint, null);
        }
        this.nodes.clear();
    }

    private synchronized void refreshNodes() {
        if (this.closed) {
            return;
        }
        LOG.info("Processing change on node: {}", (Object)this.znode);
        HashMap<String, EndpointDescription> newNodes = new HashMap<String, EndpointDescription>();
        HashMap<String, EndpointDescription> prevNodes = new HashMap<String, EndpointDescription>(this.nodes);
        this.processChildren(this.znode, newNodes, prevNodes);
        LOG.debug("processChildren done. Nodes that are missing now and need to be removed: {}", prevNodes.values());
        for (EndpointDescription endpoint : prevNodes.values()) {
            this.endpointListener.endpointRemoved(endpoint, null);
        }
        this.nodes = newNodes;
    }

    private boolean processChildren(String zn, Map<String, EndpointDescription> newNodes, Map<String, EndpointDescription> prevNodes) {
        try {
            LOG.debug("Processing the children of {}", (Object)zn);
            List children = this.zk.getChildren(zn, false);
            boolean foundANode = false;
            for (String child : children) {
                String childZNode = zn + '/' + child;
                EndpointDescription endpoint = this.getEndpointDescriptionFromNode(childZNode);
                if (endpoint != null) {
                    EndpointDescription prevEndpoint = prevNodes.get(child);
                    LOG.info("found new node " + zn + "/[" + child + "]   ( []->child )  props: " + endpoint.getProperties().values());
                    newNodes.put(child, endpoint);
                    prevNodes.remove(child);
                    foundANode = true;
                    LOG.debug("Properties: {}", (Object)endpoint.getProperties());
                    if (prevEndpoint == null) {
                        this.endpointListener.endpointAdded(endpoint, null);
                    } else if (!prevEndpoint.getProperties().equals(endpoint.getProperties())) {
                        // empty if block
                    }
                }
                if (!this.recursive || !this.processChildren(childZNode, newNodes, prevNodes)) continue;
                this.zk.getChildren(childZNode, (Watcher)this);
            }
            return foundANode;
        }
        catch (KeeperException e) {
            LOG.error("Problem processing ZooKeeper node", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Problem processing ZooKeeper node", (Throwable)e);
        }
        return false;
    }

    private EndpointDescription getEndpointDescriptionFromNode(String node) {
        try {
            Stat stat = this.zk.exists(node, false);
            if (stat == null || stat.getDataLength() <= 0) {
                return null;
            }
            byte[] data = this.zk.getData(node, false, null);
            LOG.debug("Got data for node: {}", (Object)node);
            EndpointDescription endpoint = this.parser.readEndpoint((InputStream)new ByteArrayInputStream(data));
            if (endpoint != null) {
                return endpoint;
            }
            LOG.warn("No Discovery information found for node: {}", (Object)node);
        }
        catch (Exception e) {
            LOG.error("Problem getting EndpointDescription from node " + node, (Throwable)e);
        }
        return null;
    }
}

