/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.subscribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.rsa.discovery.zookeeper.subscribe.InterfaceMonitor;
import org.apache.aries.rsa.discovery.zookeeper.util.Utils;
import org.apache.aries.rsa.util.StringPlus;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceMonitorManager {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceMonitorManager.class);
    private static final Pattern OBJECTCLASS_PATTERN = Pattern.compile(".*\\(objectClass=([^)]+)\\).*");
    private final BundleContext bctx;
    private final ZooKeeper zk;
    private final Map<ServiceReference<EndpointListener>, List<String>> endpointListenerScopes = new HashMap<ServiceReference<EndpointListener>, List<String>>();
    private final Map<String, Interest> interests = new HashMap<String, Interest>();

    public InterfaceMonitorManager(BundleContext bctx, ZooKeeper zk) {
        this.bctx = bctx;
        this.zk = zk;
    }

    public void addInterest(ServiceReference<EndpointListener> endpointListener) {
        if (InterfaceMonitorManager.isOurOwnEndpointListener(endpointListener)) {
            LOG.debug("Skipping our own EndpointListener");
            return;
        }
        List<String> scopes = this.getScopes(endpointListener);
        LOG.debug("adding Interests: {}", scopes);
        for (String scope : scopes) {
            String objClass = InterfaceMonitorManager.getObjectClass(scope);
            this.addInterest(endpointListener, scope, objClass);
        }
    }

    private static boolean isOurOwnEndpointListener(ServiceReference<EndpointListener> endpointListener) {
        return Boolean.parseBoolean(String.valueOf(endpointListener.getProperty("org.apache.cxf.dosgi.discovery.zookeeper")));
    }

    public synchronized void addInterest(ServiceReference<EndpointListener> endpointListener, String scope, String objClass) {
        Interest interest = this.interests.get(scope);
        if (interest == null) {
            interest = new Interest();
            this.interests.put(scope, interest);
            interest.endpointListeners.add(endpointListener);
            interest.monitor = this.createInterfaceMonitor(scope, objClass, interest);
            interest.monitor.start();
        } else {
            if (!interest.endpointListeners.contains(endpointListener)) {
                interest.endpointListeners.add(endpointListener);
            }
            for (EndpointDescription endpoint : interest.monitor.getEndpoints()) {
                this.notifyListeners(endpoint, scope, true, Arrays.asList(endpointListener));
            }
        }
        List<String> scopes = this.endpointListenerScopes.get(endpointListener);
        if (scopes == null) {
            scopes = new ArrayList<String>(1);
            this.endpointListenerScopes.put(endpointListener, scopes);
        }
        if (!scopes.contains(scope)) {
            scopes.add(scope);
        }
    }

    public synchronized void removeInterest(ServiceReference<EndpointListener> endpointListener) {
        LOG.info("removing EndpointListener interests: {}", endpointListener);
        List<String> scopes = this.endpointListenerScopes.get(endpointListener);
        if (scopes == null) {
            return;
        }
        for (String scope : scopes) {
            Interest interest = this.interests.get(scope);
            if (interest == null) continue;
            interest.endpointListeners.remove(endpointListener);
            if (!interest.endpointListeners.isEmpty()) continue;
            interest.monitor.close();
            this.interests.remove(scope);
        }
        this.endpointListenerScopes.remove(endpointListener);
    }

    protected InterfaceMonitor createInterfaceMonitor(final String scope, String objClass, final Interest interest) {
        EndpointListener endpointListener = new EndpointListener(){

            public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
                InterfaceMonitorManager.this.notifyListeners(endpoint, scope, false, interest.endpointListeners);
            }

            public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
                InterfaceMonitorManager.this.notifyListeners(endpoint, scope, true, interest.endpointListeners);
            }
        };
        return new InterfaceMonitor(this.zk, objClass, endpointListener, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(EndpointDescription endpoint, String currentScope, boolean isAdded, List<ServiceReference<EndpointListener>> endpointListeners) {
        for (ServiceReference<EndpointListener> endpointListenerRef : endpointListeners) {
            EndpointListener service = (EndpointListener)this.bctx.getService(endpointListenerRef);
            try {
                EndpointListener endpointListener = service;
                LOG.trace("matching {} against {}", (Object)endpoint, (Object)currentScope);
                if (!InterfaceMonitorManager.matchFilter(this.bctx, currentScope, endpoint)) continue;
                LOG.debug("Matched {} against {}", (Object)endpoint, (Object)currentScope);
                this.notifyListener(endpoint, currentScope, isAdded, endpointListenerRef.getBundle(), endpointListener);
            }
            finally {
                if (service == null) continue;
                this.bctx.ungetService(endpointListenerRef);
            }
        }
    }

    private static boolean matchFilter(BundleContext bctx, String filter, EndpointDescription endpoint) {
        if (filter == null) {
            return false;
        }
        try {
            Filter f = bctx.createFilter(filter);
            Hashtable dict = new Hashtable(endpoint.getProperties());
            return f.match(dict);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void notifyListener(EndpointDescription endpoint, String currentScope, boolean isAdded, Bundle endpointListenerBundle, EndpointListener endpointListener) {
        if (endpointListenerBundle == null) {
            LOG.info("listening service was unregistered, ignoring");
        } else if (isAdded) {
            LOG.info("calling EndpointListener.endpointAdded: " + endpointListener + " from bundle " + endpointListenerBundle.getSymbolicName() + " for endpoint: " + endpoint);
            endpointListener.endpointAdded(endpoint, currentScope);
        } else {
            LOG.info("calling EndpointListener.endpointRemoved: " + endpointListener + " from bundle " + endpointListenerBundle.getSymbolicName() + " for endpoint: " + endpoint);
            endpointListener.endpointRemoved(endpoint, currentScope);
        }
    }

    public synchronized void close() {
        for (Interest interest : this.interests.values()) {
            interest.monitor.close();
        }
        this.interests.clear();
        this.endpointListenerScopes.clear();
    }

    protected synchronized Map<String, Interest> getInterests() {
        return this.interests;
    }

    protected synchronized Map<ServiceReference<EndpointListener>, List<String>> getEndpointListenerScopes() {
        return this.endpointListenerScopes;
    }

    protected List<String> getScopes(ServiceReference<?> sref) {
        return Utils.removeEmpty(StringPlus.normalize((Object)sref.getProperty("endpoint.listener.scope")));
    }

    public static String getObjectClass(String scope) {
        Matcher m = OBJECTCLASS_PATTERN.matcher(scope);
        return m.matches() ? m.group(1) : null;
    }

    public static Map<String, Object> getProperties(ServiceReference<?> serviceReference) {
        String[] keys = serviceReference.getPropertyKeys();
        HashMap<String, Object> props = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            Object val = serviceReference.getProperty(key);
            props.put(key, val);
        }
        return props;
    }

    protected static class Interest {
        List<ServiceReference<EndpointListener>> endpointListeners = new CopyOnWriteArrayList<ServiceReference<EndpointListener>>();
        InterfaceMonitor monitor;

        protected Interest() {
        }
    }
}

