/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.output;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.hbase.MappingDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.hbase.ServiceStatus;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingUtils;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutput;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutputData;
import org.pentaho.big.data.kettle.plugins.hbase.output.Messages;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HBaseOutput", image="HBO.svg", name="HBaseOutput.Name", description="HBaseOutput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", documentationUrl="http://wiki.pentaho.com/display/EAI/HBase+Output", i18nPackageName="org.pentaho.di.trans.steps.hbaseoutput")
@InjectionSupported(localizationPrefix="HBaseOutput.Injection.", groups={"MAPPING"})
public class HBaseOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = HBaseOutputMeta.class;
    @Injection(name="HBASE_SITE_XML_URL")
    protected String m_coreConfigURL;
    @Injection(name="HBASE_DEFAULT_XML_URL")
    protected String m_defaultConfigURL;
    @Injection(name="TARGET_TABLE_NAME")
    protected String m_targetTableName;
    @Injection(name="TARGET_MAPPING_NAME")
    protected String m_targetMappingName;
    @Injection(name="DISABLE_WRITE_TO_WAL")
    protected boolean m_disableWriteToWAL;
    @Injection(name="WRITE_BUFFER_SIZE")
    protected String m_writeBufferSize;
    protected Mapping m_mapping;
    @InjectionDeep
    protected MappingDefinition mappingDefinition;
    private NamedCluster namedCluster;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil;
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private ServiceStatus serviceStatus = ServiceStatus.OK;

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public HBaseOutputMeta(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this(namedClusterService, namedClusterServiceLocator, runtimeTestActionService, runtimeTester, new NamedClusterLoadSaveUtil());
    }

    @VisibleForTesting
    protected HBaseOutputMeta(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterLoadSaveUtil namedClusterLoadSaveUtil) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterLoadSaveUtil = namedClusterLoadSaveUtil;
    }

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public void setCoreConfigURL(String coreConfig) {
        this.m_coreConfigURL = coreConfig;
    }

    public String getCoreConfigURL() {
        return this.m_coreConfigURL;
    }

    public void setDefaulConfigURL(String defaultConfig) {
        this.m_defaultConfigURL = defaultConfig;
    }

    public String getDefaultConfigURL() {
        return this.m_defaultConfigURL;
    }

    public void setTargetTableName(String targetTable) {
        this.m_targetTableName = targetTable;
    }

    public String getTargetTableName() {
        return this.m_targetTableName;
    }

    public void setTargetMappingName(String targetMapping) {
        this.m_targetMappingName = targetMapping;
    }

    public String getTargetMappingName() {
        return this.m_targetMappingName;
    }

    public void setDisableWriteToWAL(boolean d) {
        this.m_disableWriteToWAL = d;
    }

    public boolean getDisableWriteToWAL() {
        return this.m_disableWriteToWAL;
    }

    public void setWriteBufferSize(String size) {
        this.m_writeBufferSize = size;
    }

    public String getWriteBufferSize() {
        return this.m_writeBufferSize;
    }

    void applyInjection(VariableSpace space) throws KettleException {
        if (this.namedCluster == null) {
            throw new KettleException("Named cluster was not initialized!");
        }
        try {
            if (this.mappingDefinition == null) {
                ServiceStatus serviceStatus = this.getServiceStatus();
                if (!serviceStatus.isOk()) {
                    throw serviceStatus.getException();
                }
                return;
            }
            HBaseService hBaseService = this.getService();
            Mapping tempMapping = null;
            tempMapping = this.getMapping(this.mappingDefinition, hBaseService);
            this.setMapping(tempMapping);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @VisibleForTesting
    Mapping getMapping(MappingDefinition mappingDefinition, HBaseService hBaseService) throws KettleException {
        return MappingUtils.getMapping(mappingDefinition, hBaseService);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getXML() {
        try {
            this.applyInjection((VariableSpace)new Variables());
        }
        catch (KettleException e) {
            this.logError("Error occurred while injecting metadata. Transformation meta could be incorrect!", e);
        }
        StringBuilder retval = new StringBuilder();
        this.namedClusterLoadSaveUtil.getXml(retval, this.namedClusterService, this.namedCluster, this.repository == null ? null : this.repository.getMetaStore(), this.getLog());
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"core_config_url", (String)this.m_coreConfigURL));
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"default_config_url", (String)this.m_defaultConfigURL));
        }
        if (!Const.isEmpty((String)this.m_targetTableName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"target_table_name", (String)this.m_targetTableName));
        }
        if (!Const.isEmpty((String)this.m_targetMappingName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"target_mapping_name", (String)this.m_targetMappingName));
        }
        if (!Const.isEmpty((String)this.m_writeBufferSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"write_buffer_size", (String)this.m_writeBufferSize));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"disable_wal", (boolean)this.m_disableWriteToWAL));
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new HBaseOutputData();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, null, metaStore, stepnode, this.getLog());
        this.m_coreConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"core_config_url");
        this.m_defaultConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"default_config_url");
        this.m_targetTableName = XMLHandler.getTagValue((Node)stepnode, (String)"target_table_name");
        this.m_targetMappingName = XMLHandler.getTagValue((Node)stepnode, (String)"target_mapping_name");
        this.m_writeBufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"write_buffer_size");
        String disableWAL = XMLHandler.getTagValue((Node)stepnode, (String)"disable_wal");
        this.m_disableWriteToWAL = disableWAL.equalsIgnoreCase("Y");
        Mapping tempMapping = null;
        try {
            tempMapping = this.getService().getMappingFactory().createMapping();
        }
        catch (Exception e) {
            this.getLog().logError(e.getMessage());
        }
        this.m_mapping = tempMapping != null && tempMapping.loadXML(stepnode) ? tempMapping : null;
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, id_step, rep, metaStore, null, this.getLog());
        this.m_coreConfigURL = rep.getStepAttributeString(id_step, 0, "core_config_url");
        this.m_defaultConfigURL = rep.getStepAttributeString(id_step, 0, "default_config_url");
        this.m_targetTableName = rep.getStepAttributeString(id_step, 0, "target_table_name");
        this.m_targetMappingName = rep.getStepAttributeString(id_step, 0, "target_mapping_name");
        this.m_writeBufferSize = rep.getStepAttributeString(id_step, 0, "write_buffer_size");
        this.m_disableWriteToWAL = rep.getStepAttributeBoolean(id_step, 0, "disable_wal");
        Mapping tempMapping = null;
        try {
            tempMapping = this.getService().getMappingFactory().createMapping();
        }
        catch (Exception e) {
            this.getLog().logError(e.getMessage());
        }
        this.m_mapping = tempMapping != null && tempMapping.readRep(rep, id_step) ? tempMapping : null;
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        this.namedClusterLoadSaveUtil.saveRep(rep, metaStore, id_transformation, id_step, this.namedClusterService, this.namedCluster, this.getLog());
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "core_config_url", this.m_coreConfigURL);
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "default_config_url", this.m_defaultConfigURL);
        }
        if (!Const.isEmpty((String)this.m_targetTableName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "target_table_name", this.m_targetTableName);
        }
        if (!Const.isEmpty((String)this.m_targetMappingName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "target_mapping_name", this.m_targetMappingName);
        }
        if (!Const.isEmpty((String)this.m_writeBufferSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "write_buffer_size", this.m_writeBufferSize);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "disable_wal", this.m_disableWriteToWAL);
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public void setDefault() {
        this.m_coreConfigURL = null;
        this.m_defaultConfigURL = null;
        this.m_targetTableName = null;
        this.m_targetMappingName = null;
        this.m_disableWriteToWAL = false;
        this.m_writeBufferSize = null;
        this.namedCluster = this.namedClusterService.getClusterTemplate();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public MappingDefinition getMappingDefinition() {
        return this.mappingDefinition;
    }

    public void setMappingDefinition(MappingDefinition mappingDefinition) {
        this.mappingDefinition = mappingDefinition;
    }

    protected HBaseService getService() throws ClusterInitializationException {
        HBaseService service = null;
        try {
            service = (HBaseService)this.namedClusterServiceLocator.getService(this.namedCluster, HBaseService.class);
            this.serviceStatus = ServiceStatus.OK;
        }
        catch (Exception e) {
            this.serviceStatus = ServiceStatus.notOk(e);
            this.logError(Messages.getString("HBaseOutput.Error.ServiceStatus"));
            throw e;
        }
        return service;
    }

    public ServiceStatus getServiceStatus() {
        if (this.serviceStatus == null) {
            this.serviceStatus = ServiceStatus.OK;
        }
        return this.serviceStatus;
    }
}

