/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.scr.command.action.ListAction;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.SubShellAction;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrActionSupport
extends SubShellAction {
    @Option(name="-s", aliases={"--show-hidden"}, description="Show all Components including the System Components (hidden by default)", required=false, multiValued=false)
    boolean showHidden = false;
    public static final String SHOW_ALL_OPTION = "-s";
    public static final String SHOW_ALL_ALIAS = "--show-hidden";
    protected final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private ScrService scrService;

    public ScrActionSupport() {
        this.setSubShell("scr");
    }

    public Object doExecute() throws Exception {
        if (this.scrService == null) {
            String msg = "ScrService is unavailable";
            System.out.println(msg);
            this.logger.warn(msg);
        } else {
            this.doScrAction(this.scrService);
        }
        return null;
    }

    protected abstract Object doScrAction(ScrService var1) throws Exception;

    protected boolean isActionable(Component component) {
        boolean answer = true;
        return answer;
    }

    public static boolean showHiddenComponent(Component component) {
        List<String> arguments;
        boolean answer = false;
        CommandSession commandSession = CommandSessionHolder.getSession();
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        if (list != null && list.getArguments() != null && list.getArguments().length > 0 && ((arguments = Arrays.asList(list.getArguments())).contains(SHOW_ALL_OPTION) || arguments.contains(SHOW_ALL_ALIAS))) {
            answer = true;
        }
        return answer;
    }

    public static boolean isHiddenComponent(Component component) {
        String value;
        boolean answer = false;
        Hashtable properties = (Hashtable)component.getProperties();
        if (properties != null && properties.containsKey("hidden.component") && (value = (String)properties.get("hidden.component")) != null && value.equals("true")) {
            answer = true;
        }
        return answer;
    }

    public BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(ListAction.class).getBundleContext();
    }

    public ScrService getScrService() {
        return this.scrService;
    }

    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }
}

